package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.PipelineName
import scala.jdk.CollectionConverters._
final case class DeletePipelineRequest(pipelineName: PipelineName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DeletePipelineRequest = {
    import DeletePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DeletePipelineRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DeletePipelineRequest.ReadOnly =
    zio.aws.iotanalytics.model.DeletePipelineRequest.wrap(buildAwsValue())
}
object DeletePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DeletePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DeletePipelineRequest =
      zio.aws.iotanalytics.model.DeletePipelineRequest(pipelineName)
    def pipelineName: PipelineName
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DeletePipelineRequest
  ) extends zio.aws.iotanalytics.model.DeletePipelineRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.iotanalytics.model.primitives.PipelineName(impl.pipelineName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DeletePipelineRequest
  ): zio.aws.iotanalytics.model.DeletePipelineRequest.ReadOnly = new Wrapper(
    impl
  )
}
