package zio.aws.iot1clickprojects.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iot1clickprojects.model.primitives.{
  Time,
  ProjectName,
  TagValue,
  ProjectArn,
  Description,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class ProjectDescription(
    arn: Optional[ProjectArn] = Optional.Absent,
    projectName: ProjectName,
    description: Optional[Description] = Optional.Absent,
    createdDate: Time,
    updatedDate: Time,
    placementTemplate: Optional[
      zio.aws.iot1clickprojects.model.PlacementTemplate
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.ProjectDescription = {
    import ProjectDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.ProjectDescription
      .builder()
      .optionallyWith(
        arn.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.arn)
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .createdDate(Time.unwrap(createdDate): Instant)
      .updatedDate(Time.unwrap(updatedDate): Instant)
      .optionallyWith(placementTemplate.map(value => value.buildAwsValue()))(
        _.placementTemplate
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot1clickprojects.model.ProjectDescription.ReadOnly =
    zio.aws.iot1clickprojects.model.ProjectDescription.wrap(buildAwsValue())
}
object ProjectDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.ProjectDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.ProjectDescription =
      zio.aws.iot1clickprojects.model.ProjectDescription(
        arn.map(value => value),
        projectName,
        description.map(value => value),
        createdDate,
        updatedDate,
        placementTemplate.map(value => value.asEditable),
        tags.map(value => value)
      )
    def arn: Optional[ProjectArn]
    def projectName: ProjectName
    def description: Optional[Description]
    def createdDate: Time
    def updatedDate: Time
    def placementTemplate
        : Optional[zio.aws.iot1clickprojects.model.PlacementTemplate.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedDate: ZIO[Any, Nothing, Time] = ZIO.succeed(createdDate)
    def getUpdatedDate: ZIO[Any, Nothing, Time] = ZIO.succeed(updatedDate)
    def getPlacementTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.iot1clickprojects.model.PlacementTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("placementTemplate", placementTemplate)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.ProjectDescription
  ) extends zio.aws.iot1clickprojects.model.ProjectDescription.ReadOnly {
    override val arn: Optional[ProjectArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.iot1clickprojects.model.primitives.ProjectArn(value)
      )
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.iot1clickprojects.model.primitives.Description(value)
      )
    override val createdDate: Time =
      zio.aws.iot1clickprojects.model.primitives.Time(impl.createdDate())
    override val updatedDate: Time =
      zio.aws.iot1clickprojects.model.primitives.Time(impl.updatedDate())
    override val placementTemplate
        : Optional[zio.aws.iot1clickprojects.model.PlacementTemplate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementTemplate())
        .map(value =>
          zio.aws.iot1clickprojects.model.PlacementTemplate.wrap(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot1clickprojects.model.primitives.TagKey(
              key
            ) -> zio.aws.iot1clickprojects.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.ProjectDescription
  ): zio.aws.iot1clickprojects.model.ProjectDescription.ReadOnly = new Wrapper(
    impl
  )
}
