package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPlacementsResponse(
    placements: Iterable[zio.aws.iot1clickprojects.model.PlacementSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsResponse = {
    import ListPlacementsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsResponse
      .builder()
      .placements(placements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.ListPlacementsResponse.ReadOnly =
    zio.aws.iot1clickprojects.model.ListPlacementsResponse.wrap(buildAwsValue())
}
object ListPlacementsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.ListPlacementsResponse =
      zio.aws.iot1clickprojects.model.ListPlacementsResponse(
        placements.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def placements
        : List[zio.aws.iot1clickprojects.model.PlacementSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getPlacements: ZIO[Any, Nothing, List[
      zio.aws.iot1clickprojects.model.PlacementSummary.ReadOnly
    ]] = ZIO.succeed(placements)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsResponse
  ) extends zio.aws.iot1clickprojects.model.ListPlacementsResponse.ReadOnly {
    override val placements
        : List[zio.aws.iot1clickprojects.model.PlacementSummary.ReadOnly] = impl
      .placements()
      .asScala
      .map { item =>
        zio.aws.iot1clickprojects.model.PlacementSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot1clickprojects.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsResponse
  ): zio.aws.iot1clickprojects.model.ListPlacementsResponse.ReadOnly =
    new Wrapper(impl)
}
