package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{
  Time,
  AttributeName,
  ProjectName,
  PlacementName,
  AttributeValue
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class PlacementDescription(
    projectName: ProjectName,
    placementName: PlacementName,
    attributes: Map[AttributeName, AttributeValue],
    createdDate: Time,
    updatedDate: Time
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.PlacementDescription = {
    import PlacementDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.PlacementDescription
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .placementName(PlacementName.unwrap(placementName): java.lang.String)
      .attributes(
        attributes
          .map({ case (key, value) =>
            (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .createdDate(Time.unwrap(createdDate): Instant)
      .updatedDate(Time.unwrap(updatedDate): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.PlacementDescription.ReadOnly =
    zio.aws.iot1clickprojects.model.PlacementDescription.wrap(buildAwsValue())
}
object PlacementDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.PlacementDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.PlacementDescription =
      zio.aws.iot1clickprojects.model.PlacementDescription(
        projectName,
        placementName,
        attributes,
        createdDate,
        updatedDate
      )
    def projectName: ProjectName
    def placementName: PlacementName
    def attributes: Map[AttributeName, AttributeValue]
    def createdDate: Time
    def updatedDate: Time
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getPlacementName: ZIO[Any, Nothing, PlacementName] =
      ZIO.succeed(placementName)
    def getAttributes: ZIO[Any, Nothing, Map[AttributeName, AttributeValue]] =
      ZIO.succeed(attributes)
    def getCreatedDate: ZIO[Any, Nothing, Time] = ZIO.succeed(createdDate)
    def getUpdatedDate: ZIO[Any, Nothing, Time] = ZIO.succeed(updatedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.PlacementDescription
  ) extends zio.aws.iot1clickprojects.model.PlacementDescription.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
    override val placementName: PlacementName =
      zio.aws.iot1clickprojects.model.primitives
        .PlacementName(impl.placementName())
    override val attributes: Map[AttributeName, AttributeValue] = impl
      .attributes()
      .asScala
      .map({ case (key, value) =>
        zio.aws.iot1clickprojects.model.primitives.AttributeName(
          key
        ) -> zio.aws.iot1clickprojects.model.primitives.AttributeValue(value)
      })
      .toMap
    override val createdDate: Time =
      zio.aws.iot1clickprojects.model.primitives.Time(impl.createdDate())
    override val updatedDate: Time =
      zio.aws.iot1clickprojects.model.primitives.Time(impl.updatedDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.PlacementDescription
  ): zio.aws.iot1clickprojects.model.PlacementDescription.ReadOnly =
    new Wrapper(impl)
}
