package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{ProjectName, PlacementName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePlacementRequest(
    placementName: PlacementName,
    projectName: ProjectName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.DeletePlacementRequest = {
    import DeletePlacementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.DeletePlacementRequest
      .builder()
      .placementName(PlacementName.unwrap(placementName): java.lang.String)
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.DeletePlacementRequest.ReadOnly =
    zio.aws.iot1clickprojects.model.DeletePlacementRequest.wrap(buildAwsValue())
}
object DeletePlacementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.DeletePlacementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.DeletePlacementRequest =
      zio.aws.iot1clickprojects.model
        .DeletePlacementRequest(placementName, projectName)
    def placementName: PlacementName
    def projectName: ProjectName
    def getPlacementName: ZIO[Any, Nothing, PlacementName] =
      ZIO.succeed(placementName)
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.DeletePlacementRequest
  ) extends zio.aws.iot1clickprojects.model.DeletePlacementRequest.ReadOnly {
    override val placementName: PlacementName =
      zio.aws.iot1clickprojects.model.primitives
        .PlacementName(impl.placementName())
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.DeletePlacementRequest
  ): zio.aws.iot1clickprojects.model.DeletePlacementRequest.ReadOnly =
    new Wrapper(impl)
}
