package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{
  DeviceTemplateName,
  PlacementName,
  ProjectName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateDeviceFromPlacementRequest(
    projectName: ProjectName,
    placementName: PlacementName,
    deviceTemplateName: DeviceTemplateName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest = {
    import DisassociateDeviceFromPlacementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .placementName(PlacementName.unwrap(placementName): java.lang.String)
      .deviceTemplateName(
        DeviceTemplateName.unwrap(deviceTemplateName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest.ReadOnly =
    zio.aws.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest
      .wrap(buildAwsValue())
}
object DisassociateDeviceFromPlacementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest =
      zio.aws.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest(
        projectName,
        placementName,
        deviceTemplateName
      )
    def projectName: ProjectName
    def placementName: PlacementName
    def deviceTemplateName: DeviceTemplateName
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getPlacementName: ZIO[Any, Nothing, PlacementName] =
      ZIO.succeed(placementName)
    def getDeviceTemplateName: ZIO[Any, Nothing, DeviceTemplateName] =
      ZIO.succeed(deviceTemplateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest
  ) extends zio.aws.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
    override val placementName: PlacementName =
      zio.aws.iot1clickprojects.model.primitives
        .PlacementName(impl.placementName())
    override val deviceTemplateName: DeviceTemplateName =
      zio.aws.iot1clickprojects.model.primitives
        .DeviceTemplateName(impl.deviceTemplateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest
  ): zio.aws.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest.ReadOnly =
    new Wrapper(impl)
}
