package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.ProjectName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteProjectRequest(projectName: ProjectName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.DeleteProjectRequest = {
    import DeleteProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.DeleteProjectRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.DeleteProjectRequest.ReadOnly =
    zio.aws.iot1clickprojects.model.DeleteProjectRequest.wrap(buildAwsValue())
}
object DeleteProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.DeleteProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.DeleteProjectRequest =
      zio.aws.iot1clickprojects.model.DeleteProjectRequest(projectName)
    def projectName: ProjectName
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.DeleteProjectRequest
  ) extends zio.aws.iot1clickprojects.model.DeleteProjectRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.DeleteProjectRequest
  ): zio.aws.iot1clickprojects.model.DeleteProjectRequest.ReadOnly =
    new Wrapper(impl)
}
