package zio.aws.iot1clickprojects.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeProjectResponse(
    project: zio.aws.iot1clickprojects.model.ProjectDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.DescribeProjectResponse = {
    import DescribeProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.DescribeProjectResponse
      .builder()
      .project(project.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.DescribeProjectResponse.ReadOnly =
    zio.aws.iot1clickprojects.model.DescribeProjectResponse
      .wrap(buildAwsValue())
}
object DescribeProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.DescribeProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.DescribeProjectResponse =
      zio.aws.iot1clickprojects.model
        .DescribeProjectResponse(project.asEditable)
    def project: zio.aws.iot1clickprojects.model.ProjectDescription.ReadOnly
    def getProject: ZIO[
      Any,
      Nothing,
      zio.aws.iot1clickprojects.model.ProjectDescription.ReadOnly
    ] = ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.DescribeProjectResponse
  ) extends zio.aws.iot1clickprojects.model.DescribeProjectResponse.ReadOnly {
    override val project
        : zio.aws.iot1clickprojects.model.ProjectDescription.ReadOnly =
      zio.aws.iot1clickprojects.model.ProjectDescription.wrap(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.DescribeProjectResponse
  ): zio.aws.iot1clickprojects.model.DescribeProjectResponse.ReadOnly =
    new Wrapper(impl)
}
