package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{TagKey, ProjectArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: ProjectArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.UntagResourceRequest
      .builder()
      .resourceArn(ProjectArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.UntagResourceRequest.ReadOnly =
    zio.aws.iot1clickprojects.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.UntagResourceRequest =
      zio.aws.iot1clickprojects.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: ProjectArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, ProjectArn] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.UntagResourceRequest
  ) extends zio.aws.iot1clickprojects.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: ProjectArn =
      zio.aws.iot1clickprojects.model.primitives.ProjectArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.iot1clickprojects.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.UntagResourceRequest
  ): zio.aws.iot1clickprojects.model.UntagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
