package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{
  AttributeValue,
  AttributeName,
  ProjectName,
  PlacementName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdatePlacementRequest(
    placementName: PlacementName,
    projectName: ProjectName,
    attributes: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.UpdatePlacementRequest = {
    import UpdatePlacementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.UpdatePlacementRequest
      .builder()
      .placementName(PlacementName.unwrap(placementName): java.lang.String)
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.UpdatePlacementRequest.ReadOnly =
    zio.aws.iot1clickprojects.model.UpdatePlacementRequest.wrap(buildAwsValue())
}
object UpdatePlacementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.UpdatePlacementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.UpdatePlacementRequest =
      zio.aws.iot1clickprojects.model.UpdatePlacementRequest(
        placementName,
        projectName,
        attributes.map(value => value)
      )
    def placementName: PlacementName
    def projectName: ProjectName
    def attributes: Optional[Map[AttributeName, AttributeValue]]
    def getPlacementName: ZIO[Any, Nothing, PlacementName] =
      ZIO.succeed(placementName)
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.UpdatePlacementRequest
  ) extends zio.aws.iot1clickprojects.model.UpdatePlacementRequest.ReadOnly {
    override val placementName: PlacementName =
      zio.aws.iot1clickprojects.model.primitives
        .PlacementName(impl.placementName())
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
    override val attributes: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot1clickprojects.model.primitives.AttributeName(
                key
              ) -> zio.aws.iot1clickprojects.model.primitives
                .AttributeValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.UpdatePlacementRequest
  ): zio.aws.iot1clickprojects.model.UpdatePlacementRequest.ReadOnly =
    new Wrapper(impl)
}
