package zio.aws.iot1clickprojects
import zio.aws.iot1clickprojects.model.TagResourceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.iot1clickprojects.paginators.{
  ListPlacementsPublisher,
  ListProjectsPublisher
}
import software.amazon.awssdk.services.iot1clickprojects.model.{
  DescribeProjectResponse,
  DeletePlacementRequest,
  CreatePlacementResponse,
  ListPlacementsResponse,
  DescribePlacementResponse,
  CreateProjectRequest,
  DescribePlacementRequest,
  DeletePlacementResponse,
  DisassociateDeviceFromPlacementResponse,
  ListProjectsResponse,
  AssociateDeviceWithPlacementResponse,
  DisassociateDeviceFromPlacementRequest,
  ListTagsForResourceRequest,
  UpdatePlacementRequest,
  UpdatePlacementResponse,
  UpdateProjectRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  PlacementSummary,
  DeleteProjectRequest,
  GetDevicesInPlacementResponse,
  CreateProjectResponse,
  CreatePlacementRequest,
  ListProjectsRequest,
  UntagResourceRequest,
  ProjectSummary,
  GetDevicesInPlacementRequest,
  AssociateDeviceWithPlacementRequest,
  UpdateProjectResponse,
  TagResourceResponse,
  DeleteProjectResponse,
  ListPlacementsRequest,
  DescribeProjectRequest,
  TagResourceRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.iot1clickprojects.{
  Iot1ClickProjectsAsyncClientBuilder,
  Iot1ClickProjectsAsyncClient
}
import scala.jdk.CollectionConverters._
trait Iot1ClickProjects extends AspectSupport[Iot1ClickProjects] {
  val api: Iot1ClickProjectsAsyncClient
  def deletePlacement(
      request: zio.aws.iot1clickprojects.model.DeletePlacementRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickprojects.model.DeletePlacementResponse.ReadOnly
  ]
  def updateProject(
      request: zio.aws.iot1clickprojects.model.UpdateProjectRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickprojects.model.UpdateProjectResponse.ReadOnly
  ]
  def updatePlacement(
      request: zio.aws.iot1clickprojects.model.UpdatePlacementRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickprojects.model.UpdatePlacementResponse.ReadOnly
  ]
  def listProjects(
      request: zio.aws.iot1clickprojects.model.ListProjectsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iot1clickprojects.model.ProjectSummary.ReadOnly
  ]
  def listProjectsPaginated(
      request: zio.aws.iot1clickprojects.model.ListProjectsRequest
  ): IO[AwsError, zio.aws.iot1clickprojects.model.ListProjectsResponse.ReadOnly]
  def getDevicesInPlacement(
      request: zio.aws.iot1clickprojects.model.GetDevicesInPlacementRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickprojects.model.GetDevicesInPlacementResponse.ReadOnly
  ]
  def associateDeviceWithPlacement(
      request: zio.aws.iot1clickprojects.model.AssociateDeviceWithPlacementRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickprojects.model.AssociateDeviceWithPlacementResponse.ReadOnly
  ]
  def listPlacements(
      request: zio.aws.iot1clickprojects.model.ListPlacementsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iot1clickprojects.model.PlacementSummary.ReadOnly
  ]
  def listPlacementsPaginated(
      request: zio.aws.iot1clickprojects.model.ListPlacementsRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickprojects.model.ListPlacementsResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.iot1clickprojects.model.UntagResourceRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickprojects.model.UntagResourceResponse.ReadOnly
  ]
  def createProject(
      request: zio.aws.iot1clickprojects.model.CreateProjectRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickprojects.model.CreateProjectResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.iot1clickprojects.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickprojects.model.ListTagsForResourceResponse.ReadOnly
  ]
  def describeProject(
      request: zio.aws.iot1clickprojects.model.DescribeProjectRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickprojects.model.DescribeProjectResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.iot1clickprojects.model.TagResourceRequest
  ): IO[AwsError, ReadOnly]
  def disassociateDeviceFromPlacement(
      request: zio.aws.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickprojects.model.DisassociateDeviceFromPlacementResponse.ReadOnly
  ]
  def createPlacement(
      request: zio.aws.iot1clickprojects.model.CreatePlacementRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickprojects.model.CreatePlacementResponse.ReadOnly
  ]
  def describePlacement(
      request: zio.aws.iot1clickprojects.model.DescribePlacementRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickprojects.model.DescribePlacementResponse.ReadOnly
  ]
  def deleteProject(
      request: zio.aws.iot1clickprojects.model.DeleteProjectRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickprojects.model.DeleteProjectResponse.ReadOnly
  ]
}
object Iot1ClickProjects {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Iot1ClickProjects] =
    customized(identity)
  def customized(
      customization: Iot1ClickProjectsAsyncClientBuilder => Iot1ClickProjectsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Iot1ClickProjects] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: Iot1ClickProjectsAsyncClientBuilder => Iot1ClickProjectsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Iot1ClickProjects] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = Iot1ClickProjectsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      Iot1ClickProjectsAsyncClient,
      Iot1ClickProjectsAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      Iot1ClickProjectsAsyncClient,
      Iot1ClickProjectsAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new Iot1ClickProjectsImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class Iot1ClickProjectsImpl[R](
      override val api: Iot1ClickProjectsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Iot1ClickProjects
      with AwsServiceBase[R] {
    override val serviceName: String = "Iot1ClickProjects"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): Iot1ClickProjectsImpl[R1] = new Iot1ClickProjectsImpl(api, newAspect, r)
    def deletePlacement(
        request: zio.aws.iot1clickprojects.model.DeletePlacementRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickprojects.model.DeletePlacementResponse.ReadOnly
    ] = asyncRequestResponse[DeletePlacementRequest, DeletePlacementResponse](
      "deletePlacement",
      api.deletePlacement
    )(request.buildAwsValue())
      .map(zio.aws.iot1clickprojects.model.DeletePlacementResponse.wrap)
      .provideEnvironment(r)
    def updateProject(
        request: zio.aws.iot1clickprojects.model.UpdateProjectRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickprojects.model.UpdateProjectResponse.ReadOnly
    ] = asyncRequestResponse[UpdateProjectRequest, UpdateProjectResponse](
      "updateProject",
      api.updateProject
    )(request.buildAwsValue())
      .map(zio.aws.iot1clickprojects.model.UpdateProjectResponse.wrap)
      .provideEnvironment(r)
    def updatePlacement(
        request: zio.aws.iot1clickprojects.model.UpdatePlacementRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickprojects.model.UpdatePlacementResponse.ReadOnly
    ] = asyncRequestResponse[UpdatePlacementRequest, UpdatePlacementResponse](
      "updatePlacement",
      api.updatePlacement
    )(request.buildAwsValue())
      .map(zio.aws.iot1clickprojects.model.UpdatePlacementResponse.wrap)
      .provideEnvironment(r)
    def listProjects(
        request: zio.aws.iot1clickprojects.model.ListProjectsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot1clickprojects.model.ProjectSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListProjectsRequest,
      ProjectSummary,
      ListProjectsPublisher
    ]("listProjects", api.listProjectsPaginator, _.projects())(
      request.buildAwsValue()
    ).map(item => zio.aws.iot1clickprojects.model.ProjectSummary.wrap(item))
      .provideEnvironment(r)
    def listProjectsPaginated(
        request: zio.aws.iot1clickprojects.model.ListProjectsRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickprojects.model.ListProjectsResponse.ReadOnly
    ] = asyncRequestResponse[ListProjectsRequest, ListProjectsResponse](
      "listProjects",
      api.listProjects
    )(request.buildAwsValue())
      .map(zio.aws.iot1clickprojects.model.ListProjectsResponse.wrap)
      .provideEnvironment(r)
    def getDevicesInPlacement(
        request: zio.aws.iot1clickprojects.model.GetDevicesInPlacementRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickprojects.model.GetDevicesInPlacementResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDevicesInPlacementRequest,
      GetDevicesInPlacementResponse
    ]("getDevicesInPlacement", api.getDevicesInPlacement)(
      request.buildAwsValue()
    ).map(zio.aws.iot1clickprojects.model.GetDevicesInPlacementResponse.wrap)
      .provideEnvironment(r)
    def associateDeviceWithPlacement(
        request: zio.aws.iot1clickprojects.model.AssociateDeviceWithPlacementRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickprojects.model.AssociateDeviceWithPlacementResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateDeviceWithPlacementRequest,
      AssociateDeviceWithPlacementResponse
    ]("associateDeviceWithPlacement", api.associateDeviceWithPlacement)(
      request.buildAwsValue()
    ).map(
      zio.aws.iot1clickprojects.model.AssociateDeviceWithPlacementResponse.wrap
    ).provideEnvironment(r)
    def listPlacements(
        request: zio.aws.iot1clickprojects.model.ListPlacementsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot1clickprojects.model.PlacementSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListPlacementsRequest,
      PlacementSummary,
      ListPlacementsPublisher
    ]("listPlacements", api.listPlacementsPaginator, _.placements())(
      request.buildAwsValue()
    ).map(item => zio.aws.iot1clickprojects.model.PlacementSummary.wrap(item))
      .provideEnvironment(r)
    def listPlacementsPaginated(
        request: zio.aws.iot1clickprojects.model.ListPlacementsRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickprojects.model.ListPlacementsResponse.ReadOnly
    ] = asyncRequestResponse[ListPlacementsRequest, ListPlacementsResponse](
      "listPlacements",
      api.listPlacements
    )(request.buildAwsValue())
      .map(zio.aws.iot1clickprojects.model.ListPlacementsResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.iot1clickprojects.model.UntagResourceRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickprojects.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(zio.aws.iot1clickprojects.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def createProject(
        request: zio.aws.iot1clickprojects.model.CreateProjectRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickprojects.model.CreateProjectResponse.ReadOnly
    ] = asyncRequestResponse[CreateProjectRequest, CreateProjectResponse](
      "createProject",
      api.createProject
    )(request.buildAwsValue())
      .map(zio.aws.iot1clickprojects.model.CreateProjectResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.iot1clickprojects.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickprojects.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.iot1clickprojects.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def describeProject(
        request: zio.aws.iot1clickprojects.model.DescribeProjectRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickprojects.model.DescribeProjectResponse.ReadOnly
    ] = asyncRequestResponse[DescribeProjectRequest, DescribeProjectResponse](
      "describeProject",
      api.describeProject
    )(request.buildAwsValue())
      .map(zio.aws.iot1clickprojects.model.DescribeProjectResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.iot1clickprojects.model.TagResourceRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.iot1clickprojects.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def disassociateDeviceFromPlacement(
        request: zio.aws.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickprojects.model.DisassociateDeviceFromPlacementResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateDeviceFromPlacementRequest,
      DisassociateDeviceFromPlacementResponse
    ]("disassociateDeviceFromPlacement", api.disassociateDeviceFromPlacement)(
      request.buildAwsValue()
    ).map(
      zio.aws.iot1clickprojects.model.DisassociateDeviceFromPlacementResponse.wrap
    ).provideEnvironment(r)
    def createPlacement(
        request: zio.aws.iot1clickprojects.model.CreatePlacementRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickprojects.model.CreatePlacementResponse.ReadOnly
    ] = asyncRequestResponse[CreatePlacementRequest, CreatePlacementResponse](
      "createPlacement",
      api.createPlacement
    )(request.buildAwsValue())
      .map(zio.aws.iot1clickprojects.model.CreatePlacementResponse.wrap)
      .provideEnvironment(r)
    def describePlacement(
        request: zio.aws.iot1clickprojects.model.DescribePlacementRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickprojects.model.DescribePlacementResponse.ReadOnly
    ] =
      asyncRequestResponse[DescribePlacementRequest, DescribePlacementResponse](
        "describePlacement",
        api.describePlacement
      )(request.buildAwsValue())
        .map(zio.aws.iot1clickprojects.model.DescribePlacementResponse.wrap)
        .provideEnvironment(r)
    def deleteProject(
        request: zio.aws.iot1clickprojects.model.DeleteProjectRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickprojects.model.DeleteProjectResponse.ReadOnly
    ] = asyncRequestResponse[DeleteProjectRequest, DeleteProjectResponse](
      "deleteProject",
      api.deleteProject
    )(request.buildAwsValue())
      .map(zio.aws.iot1clickprojects.model.DeleteProjectResponse.wrap)
      .provideEnvironment(r)
  }
  def deletePlacement(
      request: zio.aws.iot1clickprojects.model.DeletePlacementRequest
  ): ZIO[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.DeletePlacementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePlacement(request))
  def updateProject(
      request: zio.aws.iot1clickprojects.model.UpdateProjectRequest
  ): ZIO[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.UpdateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProject(request))
  def updatePlacement(
      request: zio.aws.iot1clickprojects.model.UpdatePlacementRequest
  ): ZIO[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.UpdatePlacementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePlacement(request))
  def listProjects(
      request: zio.aws.iot1clickprojects.model.ListProjectsRequest
  ): ZStream[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.ProjectSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProjects(request))
  def listProjectsPaginated(
      request: zio.aws.iot1clickprojects.model.ListProjectsRequest
  ): ZIO[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.ListProjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProjectsPaginated(request))
  def getDevicesInPlacement(
      request: zio.aws.iot1clickprojects.model.GetDevicesInPlacementRequest
  ): ZIO[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.GetDevicesInPlacementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDevicesInPlacement(request))
  def associateDeviceWithPlacement(
      request: zio.aws.iot1clickprojects.model.AssociateDeviceWithPlacementRequest
  ): ZIO[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.AssociateDeviceWithPlacementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateDeviceWithPlacement(request))
  def listPlacements(
      request: zio.aws.iot1clickprojects.model.ListPlacementsRequest
  ): ZStream[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.PlacementSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPlacements(request))
  def listPlacementsPaginated(
      request: zio.aws.iot1clickprojects.model.ListPlacementsRequest
  ): ZIO[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.ListPlacementsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPlacementsPaginated(request))
  def untagResource(
      request: zio.aws.iot1clickprojects.model.UntagResourceRequest
  ): ZIO[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createProject(
      request: zio.aws.iot1clickprojects.model.CreateProjectRequest
  ): ZIO[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.CreateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProject(request))
  def listTagsForResource(
      request: zio.aws.iot1clickprojects.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def describeProject(
      request: zio.aws.iot1clickprojects.model.DescribeProjectRequest
  ): ZIO[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.DescribeProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProject(request))
  def tagResource(
      request: zio.aws.iot1clickprojects.model.TagResourceRequest
  ): ZIO[zio.aws.iot1clickprojects.Iot1ClickProjects, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def disassociateDeviceFromPlacement(
      request: zio.aws.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest
  ): ZIO[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.DisassociateDeviceFromPlacementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateDeviceFromPlacement(request))
  def createPlacement(
      request: zio.aws.iot1clickprojects.model.CreatePlacementRequest
  ): ZIO[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.CreatePlacementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPlacement(request))
  def describePlacement(
      request: zio.aws.iot1clickprojects.model.DescribePlacementRequest
  ): ZIO[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.DescribePlacementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePlacement(request))
  def deleteProject(
      request: zio.aws.iot1clickprojects.model.DeleteProjectRequest
  ): ZIO[
    zio.aws.iot1clickprojects.Iot1ClickProjects,
    AwsError,
    zio.aws.iot1clickprojects.model.DeleteProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProject(request))
}
