package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{
  DeviceTemplateName,
  DeviceId,
  PlacementName,
  ProjectName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateDeviceWithPlacementRequest(
    projectName: ProjectName,
    placementName: PlacementName,
    deviceId: DeviceId,
    deviceTemplateName: DeviceTemplateName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.AssociateDeviceWithPlacementRequest = {
    import AssociateDeviceWithPlacementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.AssociateDeviceWithPlacementRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .placementName(PlacementName.unwrap(placementName): java.lang.String)
      .deviceId(DeviceId.unwrap(deviceId): java.lang.String)
      .deviceTemplateName(
        DeviceTemplateName.unwrap(deviceTemplateName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.AssociateDeviceWithPlacementRequest.ReadOnly =
    zio.aws.iot1clickprojects.model.AssociateDeviceWithPlacementRequest
      .wrap(buildAwsValue())
}
object AssociateDeviceWithPlacementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.AssociateDeviceWithPlacementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot1clickprojects.model.AssociateDeviceWithPlacementRequest =
      zio.aws.iot1clickprojects.model.AssociateDeviceWithPlacementRequest(
        projectName,
        placementName,
        deviceId,
        deviceTemplateName
      )
    def projectName: ProjectName
    def placementName: PlacementName
    def deviceId: DeviceId
    def deviceTemplateName: DeviceTemplateName
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getPlacementName: ZIO[Any, Nothing, PlacementName] =
      ZIO.succeed(placementName)
    def getDeviceId: ZIO[Any, Nothing, DeviceId] = ZIO.succeed(deviceId)
    def getDeviceTemplateName: ZIO[Any, Nothing, DeviceTemplateName] =
      ZIO.succeed(deviceTemplateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.AssociateDeviceWithPlacementRequest
  ) extends zio.aws.iot1clickprojects.model.AssociateDeviceWithPlacementRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
    override val placementName: PlacementName =
      zio.aws.iot1clickprojects.model.primitives
        .PlacementName(impl.placementName())
    override val deviceId: DeviceId =
      zio.aws.iot1clickprojects.model.primitives.DeviceId(impl.deviceId())
    override val deviceTemplateName: DeviceTemplateName =
      zio.aws.iot1clickprojects.model.primitives
        .DeviceTemplateName(impl.deviceTemplateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.AssociateDeviceWithPlacementRequest
  ): zio.aws.iot1clickprojects.model.AssociateDeviceWithPlacementRequest.ReadOnly =
    new Wrapper(impl)
}
