package zio.aws.iot1clickprojects
import zio.aws.iot1clickprojects.model.primitives.{
  AttributeName,
  DeviceCallbackValue,
  DeviceId,
  AttributeDefaultValue,
  TagValue,
  DeviceTemplateName,
  DeviceCallbackKey,
  AttributeValue,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.iot1clickprojects.model.primitives.AttributeValue.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AttributeDefaultValue extends Subtype[String]
    type AttributeDefaultValue =
      zio.aws.iot1clickprojects.model.primitives.AttributeDefaultValue.Type
    object AttributeName extends Subtype[String]
    type AttributeName =
      zio.aws.iot1clickprojects.model.primitives.AttributeName.Type
    object AttributeValue extends Subtype[String]
    type AttributeValue =
      zio.aws.iot1clickprojects.model.primitives.AttributeValue.Type
    object Description extends Subtype[String]
    type Description =
      zio.aws.iot1clickprojects.model.primitives.Description.Type
    object DeviceCallbackKey extends Subtype[String]
    type DeviceCallbackKey =
      zio.aws.iot1clickprojects.model.primitives.DeviceCallbackKey.Type
    object DeviceCallbackValue extends Subtype[String]
    type DeviceCallbackValue =
      zio.aws.iot1clickprojects.model.primitives.DeviceCallbackValue.Type
    object DeviceId extends Subtype[String]
    type DeviceId = zio.aws.iot1clickprojects.model.primitives.DeviceId.Type
    object DeviceTemplateName extends Subtype[String]
    type DeviceTemplateName =
      zio.aws.iot1clickprojects.model.primitives.DeviceTemplateName.Type
    object DeviceType extends Subtype[String]
    type DeviceType = zio.aws.iot1clickprojects.model.primitives.DeviceType.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.iot1clickprojects.model.primitives.MaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.iot1clickprojects.model.primitives.NextToken.Type
    object PlacementName extends Subtype[String]
    type PlacementName =
      zio.aws.iot1clickprojects.model.primitives.PlacementName.Type
    object ProjectArn extends Subtype[String]
    type ProjectArn = zio.aws.iot1clickprojects.model.primitives.ProjectArn.Type
    object ProjectName extends Subtype[String]
    type ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.iot1clickprojects.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.iot1clickprojects.model.primitives.TagValue.Type
    object Time extends Subtype[Instant]
    type Time = zio.aws.iot1clickprojects.model.primitives.Time.Type
  }
  type DefaultPlacementAttributeMap = Map[AttributeName, AttributeDefaultValue]
  type DeviceCallbackOverrideMap = Map[DeviceCallbackKey, DeviceCallbackValue]
  type DeviceMap = Map[DeviceTemplateName, DeviceId]
  type DeviceTemplateMap =
    Map[DeviceTemplateName, zio.aws.iot1clickprojects.model.DeviceTemplate]
  type PlacementAttributeMap = Map[AttributeName, AttributeValue]
  type PlacementSummaryList =
    List[zio.aws.iot1clickprojects.model.PlacementSummary]
  type ProjectSummaryList = List[zio.aws.iot1clickprojects.model.ProjectSummary]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
}
