package zio.aws.iot1clickprojects.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iot1clickprojects.model.primitives.{
  MaxResults,
  NextToken,
  ProjectName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPlacementsRequest(
    projectName: ProjectName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest = {
    import ListPlacementsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.ListPlacementsRequest.ReadOnly =
    zio.aws.iot1clickprojects.model.ListPlacementsRequest.wrap(buildAwsValue())
}
object ListPlacementsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.ListPlacementsRequest =
      zio.aws.iot1clickprojects.model.ListPlacementsRequest(
        projectName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def projectName: ProjectName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest
  ) extends zio.aws.iot1clickprojects.model.ListPlacementsRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot1clickprojects.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.iot1clickprojects.model.primitives.MaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest
  ): zio.aws.iot1clickprojects.model.ListPlacementsRequest.ReadOnly =
    new Wrapper(impl)
}
