package zio.aws.iot1clickprojects.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribePlacementResponse(
    placement: zio.aws.iot1clickprojects.model.PlacementDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.DescribePlacementResponse = {
    import DescribePlacementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.DescribePlacementResponse
      .builder()
      .placement(placement.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.DescribePlacementResponse.ReadOnly =
    zio.aws.iot1clickprojects.model.DescribePlacementResponse
      .wrap(buildAwsValue())
}
object DescribePlacementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.DescribePlacementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.DescribePlacementResponse =
      zio.aws.iot1clickprojects.model
        .DescribePlacementResponse(placement.asEditable)
    def placement: zio.aws.iot1clickprojects.model.PlacementDescription.ReadOnly
    def getPlacement: ZIO[
      Any,
      Nothing,
      zio.aws.iot1clickprojects.model.PlacementDescription.ReadOnly
    ] = ZIO.succeed(placement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.DescribePlacementResponse
  ) extends zio.aws.iot1clickprojects.model.DescribePlacementResponse.ReadOnly {
    override val placement
        : zio.aws.iot1clickprojects.model.PlacementDescription.ReadOnly =
      zio.aws.iot1clickprojects.model.PlacementDescription
        .wrap(impl.placement())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.DescribePlacementResponse
  ): zio.aws.iot1clickprojects.model.DescribePlacementResponse.ReadOnly =
    new Wrapper(impl)
}
