package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{DeviceId, DeviceTemplateName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDevicesInPlacementResponse(
    devices: Map[DeviceTemplateName, DeviceId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.GetDevicesInPlacementResponse = {
    import GetDevicesInPlacementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.GetDevicesInPlacementResponse
      .builder()
      .devices(
        devices
          .map({ case (key, value) =>
            (DeviceTemplateName.unwrap(key): java.lang.String) -> (DeviceId
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.GetDevicesInPlacementResponse.ReadOnly =
    zio.aws.iot1clickprojects.model.GetDevicesInPlacementResponse
      .wrap(buildAwsValue())
}
object GetDevicesInPlacementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.GetDevicesInPlacementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot1clickprojects.model.GetDevicesInPlacementResponse =
      zio.aws.iot1clickprojects.model.GetDevicesInPlacementResponse(devices)
    def devices: Map[DeviceTemplateName, DeviceId]
    def getDevices: ZIO[Any, Nothing, Map[DeviceTemplateName, DeviceId]] =
      ZIO.succeed(devices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.GetDevicesInPlacementResponse
  ) extends zio.aws.iot1clickprojects.model.GetDevicesInPlacementResponse.ReadOnly {
    override val devices: Map[DeviceTemplateName, DeviceId] = impl
      .devices()
      .asScala
      .map({ case (key, value) =>
        zio.aws.iot1clickprojects.model.primitives.DeviceTemplateName(
          key
        ) -> zio.aws.iot1clickprojects.model.primitives.DeviceId(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.GetDevicesInPlacementResponse
  ): zio.aws.iot1clickprojects.model.GetDevicesInPlacementResponse.ReadOnly =
    new Wrapper(impl)
}
