package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{
  TagValue,
  TagKey,
  Description,
  ProjectName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateProjectRequest(
    projectName: ProjectName,
    description: Optional[Description] = Optional.Absent,
    placementTemplate: Optional[
      zio.aws.iot1clickprojects.model.PlacementTemplate
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.CreateProjectRequest = {
    import CreateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.CreateProjectRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(placementTemplate.map(value => value.buildAwsValue()))(
        _.placementTemplate
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.CreateProjectRequest.ReadOnly =
    zio.aws.iot1clickprojects.model.CreateProjectRequest.wrap(buildAwsValue())
}
object CreateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.CreateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.CreateProjectRequest =
      zio.aws.iot1clickprojects.model.CreateProjectRequest(
        projectName,
        description.map(value => value),
        placementTemplate.map(value => value.asEditable),
        tags.map(value => value)
      )
    def projectName: ProjectName
    def description: Optional[Description]
    def placementTemplate
        : Optional[zio.aws.iot1clickprojects.model.PlacementTemplate.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getPlacementTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.iot1clickprojects.model.PlacementTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("placementTemplate", placementTemplate)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.CreateProjectRequest
  ) extends zio.aws.iot1clickprojects.model.CreateProjectRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.iot1clickprojects.model.primitives.Description(value)
      )
    override val placementTemplate
        : Optional[zio.aws.iot1clickprojects.model.PlacementTemplate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementTemplate())
        .map(value =>
          zio.aws.iot1clickprojects.model.PlacementTemplate.wrap(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot1clickprojects.model.primitives.TagKey(
              key
            ) -> zio.aws.iot1clickprojects.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.CreateProjectRequest
  ): zio.aws.iot1clickprojects.model.CreateProjectRequest.ReadOnly =
    new Wrapper(impl)
}
