package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.ProjectName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeProjectRequest(projectName: ProjectName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.DescribeProjectRequest = {
    import DescribeProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.DescribeProjectRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.DescribeProjectRequest.ReadOnly =
    zio.aws.iot1clickprojects.model.DescribeProjectRequest.wrap(buildAwsValue())
}
object DescribeProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.DescribeProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.DescribeProjectRequest =
      zio.aws.iot1clickprojects.model.DescribeProjectRequest(projectName)
    def projectName: ProjectName
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.DescribeProjectRequest
  ) extends zio.aws.iot1clickprojects.model.DescribeProjectRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.DescribeProjectRequest
  ): zio.aws.iot1clickprojects.model.DescribeProjectRequest.ReadOnly =
    new Wrapper(impl)
}
