package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{
  Time,
  PlacementName,
  ProjectName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class PlacementSummary(
    projectName: ProjectName,
    placementName: PlacementName,
    createdDate: Time,
    updatedDate: Time
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.PlacementSummary = {
    import PlacementSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.PlacementSummary
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .placementName(PlacementName.unwrap(placementName): java.lang.String)
      .createdDate(Time.unwrap(createdDate): Instant)
      .updatedDate(Time.unwrap(updatedDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iot1clickprojects.model.PlacementSummary.ReadOnly =
    zio.aws.iot1clickprojects.model.PlacementSummary.wrap(buildAwsValue())
}
object PlacementSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.PlacementSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.PlacementSummary =
      zio.aws.iot1clickprojects.model.PlacementSummary(
        projectName,
        placementName,
        createdDate,
        updatedDate
      )
    def projectName: ProjectName
    def placementName: PlacementName
    def createdDate: Time
    def updatedDate: Time
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getPlacementName: ZIO[Any, Nothing, PlacementName] =
      ZIO.succeed(placementName)
    def getCreatedDate: ZIO[Any, Nothing, Time] = ZIO.succeed(createdDate)
    def getUpdatedDate: ZIO[Any, Nothing, Time] = ZIO.succeed(updatedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.PlacementSummary
  ) extends zio.aws.iot1clickprojects.model.PlacementSummary.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
    override val placementName: PlacementName =
      zio.aws.iot1clickprojects.model.primitives
        .PlacementName(impl.placementName())
    override val createdDate: Time =
      zio.aws.iot1clickprojects.model.primitives.Time(impl.createdDate())
    override val updatedDate: Time =
      zio.aws.iot1clickprojects.model.primitives.Time(impl.updatedDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.PlacementSummary
  ): zio.aws.iot1clickprojects.model.PlacementSummary.ReadOnly = new Wrapper(
    impl
  )
}
