package zio.aws.iot1clickprojects.model
import java.lang.Integer
import zio.aws.iot1clickprojects.model.primitives.{
  MaxResults,
  NextToken,
  ProjectName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListPlacementsRequest(
    projectName: ProjectName,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest = {
    import ListPlacementsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.ListPlacementsRequest.ReadOnly =
    zio.aws.iot1clickprojects.model.ListPlacementsRequest.wrap(buildAwsValue())
}
object ListPlacementsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.ListPlacementsRequest =
      zio.aws.iot1clickprojects.model.ListPlacementsRequest(
        projectName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def projectName: ProjectName
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest
  ) extends zio.aws.iot1clickprojects.model.ListPlacementsRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot1clickprojects.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.iot1clickprojects.model.primitives.MaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest
  ): zio.aws.iot1clickprojects.model.ListPlacementsRequest.ReadOnly =
    new Wrapper(impl)
}
