package zio.aws.iot1clickprojects
import zio.aws.iot1clickprojects.model.TagResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.iot1clickprojects.model.{
  DeletePlacementRequest,
  CreateProjectRequest,
  DescribePlacementRequest,
  DisassociateDeviceFromPlacementRequest,
  ListTagsForResourceRequest,
  UpdatePlacementRequest,
  UpdateProjectRequest,
  DeleteProjectRequest,
  CreatePlacementRequest,
  ListProjectsRequest,
  UntagResourceRequest,
  GetDevicesInPlacementRequest,
  AssociateDeviceWithPlacementRequest,
  ListPlacementsRequest,
  DescribeProjectRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.iot1clickprojects.Iot1ClickProjectsAsyncClient
object Iot1ClickProjectsMock extends Mock[Iot1ClickProjects] {
  object DeletePlacement
      extends Effect[
        DeletePlacementRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.DeletePlacementResponse.ReadOnly
      ]
  object UpdateProject
      extends Effect[
        UpdateProjectRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.UpdateProjectResponse.ReadOnly
      ]
  object UpdatePlacement
      extends Effect[
        UpdatePlacementRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.UpdatePlacementResponse.ReadOnly
      ]
  object ListProjects
      extends Stream[
        ListProjectsRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.ProjectSummary.ReadOnly
      ]
  object ListProjectsPaginated
      extends Effect[
        ListProjectsRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.ListProjectsResponse.ReadOnly
      ]
  object GetDevicesInPlacement
      extends Effect[
        GetDevicesInPlacementRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.GetDevicesInPlacementResponse.ReadOnly
      ]
  object AssociateDeviceWithPlacement
      extends Effect[
        AssociateDeviceWithPlacementRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.AssociateDeviceWithPlacementResponse.ReadOnly
      ]
  object ListPlacements
      extends Stream[
        ListPlacementsRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.PlacementSummary.ReadOnly
      ]
  object ListPlacementsPaginated
      extends Effect[
        ListPlacementsRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.ListPlacementsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.UntagResourceResponse.ReadOnly
      ]
  object CreateProject
      extends Effect[
        CreateProjectRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.CreateProjectResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DescribeProject
      extends Effect[
        DescribeProjectRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.DescribeProjectResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, ReadOnly]
  object DisassociateDeviceFromPlacement
      extends Effect[
        DisassociateDeviceFromPlacementRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.DisassociateDeviceFromPlacementResponse.ReadOnly
      ]
  object CreatePlacement
      extends Effect[
        CreatePlacementRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.CreatePlacementResponse.ReadOnly
      ]
  object DescribePlacement
      extends Effect[
        DescribePlacementRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.DescribePlacementResponse.ReadOnly
      ]
  object DeleteProject
      extends Effect[
        DeleteProjectRequest,
        AwsError,
        zio.aws.iot1clickprojects.model.DeleteProjectResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Iot1ClickProjects] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Iot1ClickProjects {
          val api: Iot1ClickProjectsAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Iot1ClickProjects = this
          def deletePlacement(request: DeletePlacementRequest): IO[
            AwsError,
            zio.aws.iot1clickprojects.model.DeletePlacementResponse.ReadOnly
          ] = proxy(DeletePlacement, request)
          def updateProject(request: UpdateProjectRequest): IO[
            AwsError,
            zio.aws.iot1clickprojects.model.UpdateProjectResponse.ReadOnly
          ] = proxy(UpdateProject, request)
          def updatePlacement(request: UpdatePlacementRequest): IO[
            AwsError,
            zio.aws.iot1clickprojects.model.UpdatePlacementResponse.ReadOnly
          ] = proxy(UpdatePlacement, request)
          def listProjects(request: ListProjectsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iot1clickprojects.model.ProjectSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListProjects, request))
          def listProjectsPaginated(request: ListProjectsRequest): IO[
            AwsError,
            zio.aws.iot1clickprojects.model.ListProjectsResponse.ReadOnly
          ] = proxy(ListProjectsPaginated, request)
          def getDevicesInPlacement(request: GetDevicesInPlacementRequest): IO[
            AwsError,
            zio.aws.iot1clickprojects.model.GetDevicesInPlacementResponse.ReadOnly
          ] = proxy(GetDevicesInPlacement, request)
          def associateDeviceWithPlacement(
              request: AssociateDeviceWithPlacementRequest
          ): IO[
            AwsError,
            zio.aws.iot1clickprojects.model.AssociateDeviceWithPlacementResponse.ReadOnly
          ] = proxy(AssociateDeviceWithPlacement, request)
          def listPlacements(request: ListPlacementsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iot1clickprojects.model.PlacementSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListPlacements, request))
          def listPlacementsPaginated(request: ListPlacementsRequest): IO[
            AwsError,
            zio.aws.iot1clickprojects.model.ListPlacementsResponse.ReadOnly
          ] = proxy(ListPlacementsPaginated, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.iot1clickprojects.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def createProject(request: CreateProjectRequest): IO[
            AwsError,
            zio.aws.iot1clickprojects.model.CreateProjectResponse.ReadOnly
          ] = proxy(CreateProject, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.iot1clickprojects.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def describeProject(request: DescribeProjectRequest): IO[
            AwsError,
            zio.aws.iot1clickprojects.model.DescribeProjectResponse.ReadOnly
          ] = proxy(DescribeProject, request)
          def tagResource(request: TagResourceRequest): IO[AwsError, ReadOnly] =
            proxy(TagResource, request)
          def disassociateDeviceFromPlacement(
              request: DisassociateDeviceFromPlacementRequest
          ): IO[
            AwsError,
            zio.aws.iot1clickprojects.model.DisassociateDeviceFromPlacementResponse.ReadOnly
          ] = proxy(DisassociateDeviceFromPlacement, request)
          def createPlacement(request: CreatePlacementRequest): IO[
            AwsError,
            zio.aws.iot1clickprojects.model.CreatePlacementResponse.ReadOnly
          ] = proxy(CreatePlacement, request)
          def describePlacement(request: DescribePlacementRequest): IO[
            AwsError,
            zio.aws.iot1clickprojects.model.DescribePlacementResponse.ReadOnly
          ] = proxy(DescribePlacement, request)
          def deleteProject(request: DeleteProjectRequest): IO[
            AwsError,
            zio.aws.iot1clickprojects.model.DeleteProjectResponse.ReadOnly
          ] = proxy(DeleteProject, request)
        }
      }
    }
    .toLayer
}
