package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{TagValue, TagKey, ProjectArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ProjectArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.TagResourceRequest
      .builder()
      .resourceArn(ProjectArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.iot1clickprojects.model.TagResourceRequest.ReadOnly =
    zio.aws.iot1clickprojects.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.TagResourceRequest =
      zio.aws.iot1clickprojects.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: ProjectArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, ProjectArn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.TagResourceRequest
  ) extends zio.aws.iot1clickprojects.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ProjectArn =
      zio.aws.iot1clickprojects.model.primitives.ProjectArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.iot1clickprojects.model.primitives.TagKey(
          key
        ) -> zio.aws.iot1clickprojects.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.TagResourceRequest
  ): zio.aws.iot1clickprojects.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
