package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{PlacementName, ProjectName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDevicesInPlacementRequest(
    projectName: ProjectName,
    placementName: PlacementName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.GetDevicesInPlacementRequest = {
    import GetDevicesInPlacementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.GetDevicesInPlacementRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .placementName(PlacementName.unwrap(placementName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.GetDevicesInPlacementRequest.ReadOnly =
    zio.aws.iot1clickprojects.model.GetDevicesInPlacementRequest
      .wrap(buildAwsValue())
}
object GetDevicesInPlacementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.GetDevicesInPlacementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot1clickprojects.model.GetDevicesInPlacementRequest =
      zio.aws.iot1clickprojects.model
        .GetDevicesInPlacementRequest(projectName, placementName)
    def projectName: ProjectName
    def placementName: PlacementName
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getPlacementName: ZIO[Any, Nothing, PlacementName] =
      ZIO.succeed(placementName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.GetDevicesInPlacementRequest
  ) extends zio.aws.iot1clickprojects.model.GetDevicesInPlacementRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
    override val placementName: PlacementName =
      zio.aws.iot1clickprojects.model.primitives
        .PlacementName(impl.placementName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.GetDevicesInPlacementRequest
  ): zio.aws.iot1clickprojects.model.GetDevicesInPlacementRequest.ReadOnly =
    new Wrapper(impl)
}
