package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListProjectsResponse(
    projects: Iterable[zio.aws.iot1clickprojects.model.ProjectSummary],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsResponse = {
    import ListProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsResponse
      .builder()
      .projects(projects.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.ListProjectsResponse.ReadOnly =
    zio.aws.iot1clickprojects.model.ListProjectsResponse.wrap(buildAwsValue())
}
object ListProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.ListProjectsResponse =
      zio.aws.iot1clickprojects.model.ListProjectsResponse(
        projects.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def projects: List[zio.aws.iot1clickprojects.model.ProjectSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getProjects: ZIO[Any, Nothing, List[
      zio.aws.iot1clickprojects.model.ProjectSummary.ReadOnly
    ]] = ZIO.succeed(projects)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsResponse
  ) extends zio.aws.iot1clickprojects.model.ListProjectsResponse.ReadOnly {
    override val projects
        : List[zio.aws.iot1clickprojects.model.ProjectSummary.ReadOnly] = impl
      .projects()
      .asScala
      .map { item =>
        zio.aws.iot1clickprojects.model.ProjectSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot1clickprojects.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsResponse
  ): zio.aws.iot1clickprojects.model.ListProjectsResponse.ReadOnly =
    new Wrapper(impl)
}
