package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{
  Time,
  ProjectName,
  TagValue,
  ProjectArn,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ProjectSummary(
    arn: Option[ProjectArn] = None,
    projectName: ProjectName,
    createdDate: Time,
    updatedDate: Time,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.ProjectSummary = {
    import ProjectSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.ProjectSummary
      .builder()
      .optionallyWith(
        arn.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.arn)
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .createdDate(Time.unwrap(createdDate): Instant)
      .updatedDate(Time.unwrap(updatedDate): Instant)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot1clickprojects.model.ProjectSummary.ReadOnly =
    zio.aws.iot1clickprojects.model.ProjectSummary.wrap(buildAwsValue())
}
object ProjectSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.ProjectSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.ProjectSummary =
      zio.aws.iot1clickprojects.model.ProjectSummary(
        arn.map(value => value),
        projectName,
        createdDate,
        updatedDate,
        tags.map(value => value)
      )
    def arn: Option[ProjectArn]
    def projectName: ProjectName
    def createdDate: Time
    def updatedDate: Time
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getCreatedDate: ZIO[Any, Nothing, Time] = ZIO.succeed(createdDate)
    def getUpdatedDate: ZIO[Any, Nothing, Time] = ZIO.succeed(updatedDate)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.ProjectSummary
  ) extends zio.aws.iot1clickprojects.model.ProjectSummary.ReadOnly {
    override val arn: Option[ProjectArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.iot1clickprojects.model.primitives.ProjectArn(value)
      )
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
    override val createdDate: Time =
      zio.aws.iot1clickprojects.model.primitives.Time(impl.createdDate())
    override val updatedDate: Time =
      zio.aws.iot1clickprojects.model.primitives.Time(impl.updatedDate())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot1clickprojects.model.primitives.TagKey(
              key
            ) -> zio.aws.iot1clickprojects.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.ProjectSummary
  ): zio.aws.iot1clickprojects.model.ProjectSummary.ReadOnly = new Wrapper(impl)
}
