package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{Description, ProjectName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateProjectRequest(
    projectName: ProjectName,
    description: Option[Description] = None,
    placementTemplate: Option[
      zio.aws.iot1clickprojects.model.PlacementTemplate
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.UpdateProjectRequest = {
    import UpdateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.UpdateProjectRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(placementTemplate.map(value => value.buildAwsValue()))(
        _.placementTemplate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.UpdateProjectRequest.ReadOnly =
    zio.aws.iot1clickprojects.model.UpdateProjectRequest.wrap(buildAwsValue())
}
object UpdateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.UpdateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.UpdateProjectRequest =
      zio.aws.iot1clickprojects.model.UpdateProjectRequest(
        projectName,
        description.map(value => value),
        placementTemplate.map(value => value.asEditable)
      )
    def projectName: ProjectName
    def description: Option[Description]
    def placementTemplate
        : Option[zio.aws.iot1clickprojects.model.PlacementTemplate.ReadOnly]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getPlacementTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.iot1clickprojects.model.PlacementTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("placementTemplate", placementTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.UpdateProjectRequest
  ) extends zio.aws.iot1clickprojects.model.UpdateProjectRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.iot1clickprojects.model.primitives.Description(value)
      )
    override val placementTemplate
        : Option[zio.aws.iot1clickprojects.model.PlacementTemplate.ReadOnly] =
      scala
        .Option(impl.placementTemplate())
        .map(value =>
          zio.aws.iot1clickprojects.model.PlacementTemplate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.UpdateProjectRequest
  ): zio.aws.iot1clickprojects.model.UpdateProjectRequest.ReadOnly =
    new Wrapper(impl)
}
