package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{
  DeviceCallbackValue,
  DeviceCallbackKey,
  DeviceType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeviceTemplate(
    deviceType: Option[DeviceType] = None,
    callbackOverrides: Option[Map[DeviceCallbackKey, DeviceCallbackValue]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.DeviceTemplate = {
    import DeviceTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.DeviceTemplate
      .builder()
      .optionallyWith(
        deviceType.map(value => DeviceType.unwrap(value): java.lang.String)
      )(_.deviceType)
      .optionallyWith(
        callbackOverrides.map(value =>
          value
            .map({ case (key, value) =>
              (DeviceCallbackKey
                .unwrap(key): java.lang.String) -> (DeviceCallbackValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.callbackOverrides)
      .build()
  }
  def asReadOnly: zio.aws.iot1clickprojects.model.DeviceTemplate.ReadOnly =
    zio.aws.iot1clickprojects.model.DeviceTemplate.wrap(buildAwsValue())
}
object DeviceTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.DeviceTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.DeviceTemplate =
      zio.aws.iot1clickprojects.model.DeviceTemplate(
        deviceType.map(value => value),
        callbackOverrides.map(value => value)
      )
    def deviceType: Option[DeviceType]
    def callbackOverrides: Option[Map[DeviceCallbackKey, DeviceCallbackValue]]
    def getDeviceType: ZIO[Any, AwsError, DeviceType] =
      AwsError.unwrapOptionField("deviceType", deviceType)
    def getCallbackOverrides
        : ZIO[Any, AwsError, Map[DeviceCallbackKey, DeviceCallbackValue]] =
      AwsError.unwrapOptionField("callbackOverrides", callbackOverrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.DeviceTemplate
  ) extends zio.aws.iot1clickprojects.model.DeviceTemplate.ReadOnly {
    override val deviceType: Option[DeviceType] = scala
      .Option(impl.deviceType())
      .map(value =>
        zio.aws.iot1clickprojects.model.primitives.DeviceType(value)
      )
    override val callbackOverrides
        : Option[Map[DeviceCallbackKey, DeviceCallbackValue]] = scala
      .Option(impl.callbackOverrides())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot1clickprojects.model.primitives.DeviceCallbackKey(
              key
            ) -> zio.aws.iot1clickprojects.model.primitives
              .DeviceCallbackValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.DeviceTemplate
  ): zio.aws.iot1clickprojects.model.DeviceTemplate.ReadOnly = new Wrapper(impl)
}
