package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{
  DeviceTemplateName,
  AttributeDefaultValue,
  AttributeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PlacementTemplate(
    defaultAttributes: Option[Map[AttributeName, AttributeDefaultValue]] = None,
    deviceTemplates: Option[
      Map[DeviceTemplateName, zio.aws.iot1clickprojects.model.DeviceTemplate]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.PlacementTemplate = {
    import PlacementTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.PlacementTemplate
      .builder()
      .optionallyWith(
        defaultAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName
                .unwrap(key): java.lang.String) -> (AttributeDefaultValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.defaultAttributes)
      .optionallyWith(
        deviceTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (DeviceTemplateName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.deviceTemplates)
      .build()
  }
  def asReadOnly: zio.aws.iot1clickprojects.model.PlacementTemplate.ReadOnly =
    zio.aws.iot1clickprojects.model.PlacementTemplate.wrap(buildAwsValue())
}
object PlacementTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.PlacementTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.PlacementTemplate =
      zio.aws.iot1clickprojects.model.PlacementTemplate(
        defaultAttributes.map(value => value),
        deviceTemplates.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def defaultAttributes: Option[Map[AttributeName, AttributeDefaultValue]]
    def deviceTemplates: Option[Map[
      DeviceTemplateName,
      zio.aws.iot1clickprojects.model.DeviceTemplate.ReadOnly
    ]]
    def getDefaultAttributes
        : ZIO[Any, AwsError, Map[AttributeName, AttributeDefaultValue]] =
      AwsError.unwrapOptionField("defaultAttributes", defaultAttributes)
    def getDeviceTemplates: ZIO[Any, AwsError, Map[
      DeviceTemplateName,
      zio.aws.iot1clickprojects.model.DeviceTemplate.ReadOnly
    ]] = AwsError.unwrapOptionField("deviceTemplates", deviceTemplates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.PlacementTemplate
  ) extends zio.aws.iot1clickprojects.model.PlacementTemplate.ReadOnly {
    override val defaultAttributes
        : Option[Map[AttributeName, AttributeDefaultValue]] = scala
      .Option(impl.defaultAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot1clickprojects.model.primitives
              .AttributeName(key) -> zio.aws.iot1clickprojects.model.primitives
              .AttributeDefaultValue(value)
          })
          .toMap
      )
    override val deviceTemplates: Option[Map[
      DeviceTemplateName,
      zio.aws.iot1clickprojects.model.DeviceTemplate.ReadOnly
    ]] = scala
      .Option(impl.deviceTemplates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot1clickprojects.model.primitives.DeviceTemplateName(
              key
            ) -> zio.aws.iot1clickprojects.model.DeviceTemplate.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.PlacementTemplate
  ): zio.aws.iot1clickprojects.model.PlacementTemplate.ReadOnly = new Wrapper(
    impl
  )
}
