package zio.aws.iot1clickprojects.model
import zio.aws.iot1clickprojects.model.primitives.{
  TagValue,
  TagKey,
  Description,
  ProjectName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateProjectRequest(
    projectName: ProjectName,
    description: Option[Description] = None,
    placementTemplate: Option[
      zio.aws.iot1clickprojects.model.PlacementTemplate
    ] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickprojects.model.CreateProjectRequest = {
    import CreateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickprojects.model.CreateProjectRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(placementTemplate.map(value => value.buildAwsValue()))(
        _.placementTemplate
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickprojects.model.CreateProjectRequest.ReadOnly =
    zio.aws.iot1clickprojects.model.CreateProjectRequest.wrap(buildAwsValue())
}
object CreateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickprojects.model.CreateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickprojects.model.CreateProjectRequest =
      zio.aws.iot1clickprojects.model.CreateProjectRequest(
        projectName,
        description.map(value => value),
        placementTemplate.map(value => value.asEditable),
        tags.map(value => value)
      )
    def projectName: ProjectName
    def description: Option[Description]
    def placementTemplate
        : Option[zio.aws.iot1clickprojects.model.PlacementTemplate.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getPlacementTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.iot1clickprojects.model.PlacementTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("placementTemplate", placementTemplate)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.CreateProjectRequest
  ) extends zio.aws.iot1clickprojects.model.CreateProjectRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.iot1clickprojects.model.primitives.ProjectName(impl.projectName())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.iot1clickprojects.model.primitives.Description(value)
      )
    override val placementTemplate
        : Option[zio.aws.iot1clickprojects.model.PlacementTemplate.ReadOnly] =
      scala
        .Option(impl.placementTemplate())
        .map(value =>
          zio.aws.iot1clickprojects.model.PlacementTemplate.wrap(value)
        )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot1clickprojects.model.primitives.TagKey(
              key
            ) -> zio.aws.iot1clickprojects.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickprojects.model.CreateProjectRequest
  ): zio.aws.iot1clickprojects.model.CreateProjectRequest.ReadOnly =
    new Wrapper(impl)
}
