package zio.aws.iot1clickdevices.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot1clickdevices.model.primitives.{__boolean, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDeviceStateRequest(
    deviceId: __string,
    enabled: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.UpdateDeviceStateRequest = {
    import UpdateDeviceStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.UpdateDeviceStateRequest
      .builder()
      .deviceId(deviceId: java.lang.String)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickdevices.model.UpdateDeviceStateRequest.ReadOnly =
    zio.aws.iot1clickdevices.model.UpdateDeviceStateRequest
      .wrap(buildAwsValue())
}
object UpdateDeviceStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.UpdateDeviceStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.UpdateDeviceStateRequest =
      zio.aws.iot1clickdevices.model
        .UpdateDeviceStateRequest(deviceId, enabled.map(value => value))
    def deviceId: __string
    def enabled: Optional[__boolean]
    def getDeviceId: ZIO[Any, Nothing, __string] = ZIO.succeed(deviceId)
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.UpdateDeviceStateRequest
  ) extends zio.aws.iot1clickdevices.model.UpdateDeviceStateRequest.ReadOnly {
    override val deviceId: __string = impl.deviceId(): __string
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.UpdateDeviceStateRequest
  ): zio.aws.iot1clickdevices.model.UpdateDeviceStateRequest.ReadOnly =
    new Wrapper(impl)
}
