package zio.aws.iot1clickdevices
import zio.aws.core.config.AwsConfig
import zio.aws.iot1clickdevices.model.FinalizeDeviceClaimResponse.ReadOnly
import software.amazon.awssdk.services.iot1clickdevices.model.{
  InvokeDeviceMethodResponse,
  GetDeviceMethodsRequest,
  DescribeDeviceRequest,
  DeviceEvent,
  FinalizeDeviceClaimResponse,
  DeviceDescription,
  ListDeviceEventsResponse,
  ListDevicesResponse,
  ListTagsForResourceRequest,
  ListDeviceEventsRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  UnclaimDeviceRequest,
  ClaimDevicesByClaimCodeResponse,
  DescribeDeviceResponse,
  ClaimDevicesByClaimCodeRequest,
  GetDeviceMethodsResponse,
  InitiateDeviceClaimRequest,
  UntagResourceRequest,
  ListDevicesRequest,
  InitiateDeviceClaimResponse,
  UpdateDeviceStateRequest,
  InvokeDeviceMethodRequest,
  TagResourceResponse,
  FinalizeDeviceClaimRequest,
  UnclaimDeviceResponse,
  TagResourceRequest,
  UpdateDeviceStateResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.iot1clickdevices.{
  Iot1ClickDevicesAsyncClientBuilder,
  Iot1ClickDevicesAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Iot1ClickDevices extends AspectSupport[Iot1ClickDevices] {
  val api: Iot1ClickDevicesAsyncClient
  def initiateDeviceClaim(
      request: zio.aws.iot1clickdevices.model.InitiateDeviceClaimRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickdevices.model.InitiateDeviceClaimResponse.ReadOnly
  ]
  def describeDevice(
      request: zio.aws.iot1clickdevices.model.DescribeDeviceRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickdevices.model.DescribeDeviceResponse.ReadOnly
  ]
  def listDeviceEvents(
      request: zio.aws.iot1clickdevices.model.ListDeviceEventsRequest
  ): ZStream[Any, AwsError, zio.aws.iot1clickdevices.model.DeviceEvent.ReadOnly]
  def listDeviceEventsPaginated(
      request: zio.aws.iot1clickdevices.model.ListDeviceEventsRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickdevices.model.ListDeviceEventsResponse.ReadOnly
  ]
  def listDevices(
      request: zio.aws.iot1clickdevices.model.ListDevicesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iot1clickdevices.model.DeviceDescription.ReadOnly
  ]
  def listDevicesPaginated(
      request: zio.aws.iot1clickdevices.model.ListDevicesRequest
  ): IO[AwsError, zio.aws.iot1clickdevices.model.ListDevicesResponse.ReadOnly]
  def finalizeDeviceClaim(
      request: zio.aws.iot1clickdevices.model.FinalizeDeviceClaimRequest
  ): IO[AwsError, ReadOnly]
  def untagResource(
      request: zio.aws.iot1clickdevices.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def updateDeviceState(
      request: zio.aws.iot1clickdevices.model.UpdateDeviceStateRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickdevices.model.UpdateDeviceStateResponse.ReadOnly
  ]
  def claimDevicesByClaimCode(
      request: zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.iot1clickdevices.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickdevices.model.ListTagsForResourceResponse.ReadOnly
  ]
  def invokeDeviceMethod(
      request: zio.aws.iot1clickdevices.model.InvokeDeviceMethodRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickdevices.model.InvokeDeviceMethodResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.iot1clickdevices.model.TagResourceRequest
  ): IO[AwsError, Unit]
  def unclaimDevice(
      request: zio.aws.iot1clickdevices.model.UnclaimDeviceRequest
  ): IO[AwsError, zio.aws.iot1clickdevices.model.UnclaimDeviceResponse.ReadOnly]
  def getDeviceMethods(
      request: zio.aws.iot1clickdevices.model.GetDeviceMethodsRequest
  ): IO[
    AwsError,
    zio.aws.iot1clickdevices.model.GetDeviceMethodsResponse.ReadOnly
  ]
}
object Iot1ClickDevices {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Iot1ClickDevices] =
    customized(identity)
  def customized(
      customization: Iot1ClickDevicesAsyncClientBuilder => Iot1ClickDevicesAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Iot1ClickDevices] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: Iot1ClickDevicesAsyncClientBuilder => Iot1ClickDevicesAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Iot1ClickDevices] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = Iot1ClickDevicesAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      Iot1ClickDevicesAsyncClient,
      Iot1ClickDevicesAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      Iot1ClickDevicesAsyncClient,
      Iot1ClickDevicesAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new Iot1ClickDevicesImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class Iot1ClickDevicesImpl[R](
      override val api: Iot1ClickDevicesAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Iot1ClickDevices
      with AwsServiceBase[R] {
    override val serviceName: String = "Iot1ClickDevices"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): Iot1ClickDevicesImpl[R1] = new Iot1ClickDevicesImpl(api, newAspect, r)
    def initiateDeviceClaim(
        request: zio.aws.iot1clickdevices.model.InitiateDeviceClaimRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickdevices.model.InitiateDeviceClaimResponse.ReadOnly
    ] = asyncRequestResponse[
      InitiateDeviceClaimRequest,
      InitiateDeviceClaimResponse
    ]("initiateDeviceClaim", api.initiateDeviceClaim)(request.buildAwsValue())
      .map(zio.aws.iot1clickdevices.model.InitiateDeviceClaimResponse.wrap)
      .provideEnvironment(r)
    def describeDevice(
        request: zio.aws.iot1clickdevices.model.DescribeDeviceRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickdevices.model.DescribeDeviceResponse.ReadOnly
    ] = asyncRequestResponse[DescribeDeviceRequest, DescribeDeviceResponse](
      "describeDevice",
      api.describeDevice
    )(request.buildAwsValue())
      .map(zio.aws.iot1clickdevices.model.DescribeDeviceResponse.wrap)
      .provideEnvironment(r)
    def listDeviceEvents(
        request: zio.aws.iot1clickdevices.model.ListDeviceEventsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot1clickdevices.model.DeviceEvent.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListDeviceEventsRequest,
      ListDeviceEventsResponse,
      DeviceEvent
    ](
      "listDeviceEvents",
      api.listDeviceEvents,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.events().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.iot1clickdevices.model.DeviceEvent.wrap(item))
      .provideEnvironment(r)
    def listDeviceEventsPaginated(
        request: zio.aws.iot1clickdevices.model.ListDeviceEventsRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickdevices.model.ListDeviceEventsResponse.ReadOnly
    ] = asyncRequestResponse[ListDeviceEventsRequest, ListDeviceEventsResponse](
      "listDeviceEvents",
      api.listDeviceEvents
    )(request.buildAwsValue())
      .map(zio.aws.iot1clickdevices.model.ListDeviceEventsResponse.wrap)
      .provideEnvironment(r)
    def listDevices(
        request: zio.aws.iot1clickdevices.model.ListDevicesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot1clickdevices.model.DeviceDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListDevicesRequest,
      ListDevicesResponse,
      DeviceDescription
    ](
      "listDevices",
      api.listDevices,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.devices().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.iot1clickdevices.model.DeviceDescription.wrap(item))
      .provideEnvironment(r)
    def listDevicesPaginated(
        request: zio.aws.iot1clickdevices.model.ListDevicesRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickdevices.model.ListDevicesResponse.ReadOnly
    ] = asyncRequestResponse[ListDevicesRequest, ListDevicesResponse](
      "listDevices",
      api.listDevices
    )(request.buildAwsValue())
      .map(zio.aws.iot1clickdevices.model.ListDevicesResponse.wrap)
      .provideEnvironment(r)
    def finalizeDeviceClaim(
        request: zio.aws.iot1clickdevices.model.FinalizeDeviceClaimRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      FinalizeDeviceClaimRequest,
      FinalizeDeviceClaimResponse
    ]("finalizeDeviceClaim", api.finalizeDeviceClaim)(request.buildAwsValue())
      .map(zio.aws.iot1clickdevices.model.FinalizeDeviceClaimResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.iot1clickdevices.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateDeviceState(
        request: zio.aws.iot1clickdevices.model.UpdateDeviceStateRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickdevices.model.UpdateDeviceStateResponse.ReadOnly
    ] =
      asyncRequestResponse[UpdateDeviceStateRequest, UpdateDeviceStateResponse](
        "updateDeviceState",
        api.updateDeviceState
      )(request.buildAwsValue())
        .map(zio.aws.iot1clickdevices.model.UpdateDeviceStateResponse.wrap)
        .provideEnvironment(r)
    def claimDevicesByClaimCode(
        request: zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse.ReadOnly
    ] = asyncRequestResponse[
      ClaimDevicesByClaimCodeRequest,
      ClaimDevicesByClaimCodeResponse
    ]("claimDevicesByClaimCode", api.claimDevicesByClaimCode)(
      request.buildAwsValue()
    ).map(zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.iot1clickdevices.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickdevices.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.iot1clickdevices.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def invokeDeviceMethod(
        request: zio.aws.iot1clickdevices.model.InvokeDeviceMethodRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickdevices.model.InvokeDeviceMethodResponse.ReadOnly
    ] = asyncRequestResponse[
      InvokeDeviceMethodRequest,
      InvokeDeviceMethodResponse
    ]("invokeDeviceMethod", api.invokeDeviceMethod)(request.buildAwsValue())
      .map(zio.aws.iot1clickdevices.model.InvokeDeviceMethodResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.iot1clickdevices.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def unclaimDevice(
        request: zio.aws.iot1clickdevices.model.UnclaimDeviceRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickdevices.model.UnclaimDeviceResponse.ReadOnly
    ] = asyncRequestResponse[UnclaimDeviceRequest, UnclaimDeviceResponse](
      "unclaimDevice",
      api.unclaimDevice
    )(request.buildAwsValue())
      .map(zio.aws.iot1clickdevices.model.UnclaimDeviceResponse.wrap)
      .provideEnvironment(r)
    def getDeviceMethods(
        request: zio.aws.iot1clickdevices.model.GetDeviceMethodsRequest
    ): IO[
      AwsError,
      zio.aws.iot1clickdevices.model.GetDeviceMethodsResponse.ReadOnly
    ] = asyncRequestResponse[GetDeviceMethodsRequest, GetDeviceMethodsResponse](
      "getDeviceMethods",
      api.getDeviceMethods
    )(request.buildAwsValue())
      .map(zio.aws.iot1clickdevices.model.GetDeviceMethodsResponse.wrap)
      .provideEnvironment(r)
  }
  def initiateDeviceClaim(
      request: zio.aws.iot1clickdevices.model.InitiateDeviceClaimRequest
  ): ZIO[
    zio.aws.iot1clickdevices.Iot1ClickDevices,
    AwsError,
    zio.aws.iot1clickdevices.model.InitiateDeviceClaimResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.initiateDeviceClaim(request))
  def describeDevice(
      request: zio.aws.iot1clickdevices.model.DescribeDeviceRequest
  ): ZIO[
    zio.aws.iot1clickdevices.Iot1ClickDevices,
    AwsError,
    zio.aws.iot1clickdevices.model.DescribeDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDevice(request))
  def listDeviceEvents(
      request: zio.aws.iot1clickdevices.model.ListDeviceEventsRequest
  ): ZStream[
    zio.aws.iot1clickdevices.Iot1ClickDevices,
    AwsError,
    zio.aws.iot1clickdevices.model.DeviceEvent.ReadOnly
  ] = ZStream.serviceWithStream(_.listDeviceEvents(request))
  def listDeviceEventsPaginated(
      request: zio.aws.iot1clickdevices.model.ListDeviceEventsRequest
  ): ZIO[
    zio.aws.iot1clickdevices.Iot1ClickDevices,
    AwsError,
    zio.aws.iot1clickdevices.model.ListDeviceEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDeviceEventsPaginated(request))
  def listDevices(
      request: zio.aws.iot1clickdevices.model.ListDevicesRequest
  ): ZStream[
    zio.aws.iot1clickdevices.Iot1ClickDevices,
    AwsError,
    zio.aws.iot1clickdevices.model.DeviceDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.listDevices(request))
  def listDevicesPaginated(
      request: zio.aws.iot1clickdevices.model.ListDevicesRequest
  ): ZIO[
    zio.aws.iot1clickdevices.Iot1ClickDevices,
    AwsError,
    zio.aws.iot1clickdevices.model.ListDevicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDevicesPaginated(request))
  def finalizeDeviceClaim(
      request: zio.aws.iot1clickdevices.model.FinalizeDeviceClaimRequest
  ): ZIO[zio.aws.iot1clickdevices.Iot1ClickDevices, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.finalizeDeviceClaim(request))
  def untagResource(
      request: zio.aws.iot1clickdevices.model.UntagResourceRequest
  ): ZIO[zio.aws.iot1clickdevices.Iot1ClickDevices, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def updateDeviceState(
      request: zio.aws.iot1clickdevices.model.UpdateDeviceStateRequest
  ): ZIO[
    zio.aws.iot1clickdevices.Iot1ClickDevices,
    AwsError,
    zio.aws.iot1clickdevices.model.UpdateDeviceStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDeviceState(request))
  def claimDevicesByClaimCode(
      request: zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeRequest
  ): ZIO[
    zio.aws.iot1clickdevices.Iot1ClickDevices,
    AwsError,
    zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.claimDevicesByClaimCode(request))
  def listTagsForResource(
      request: zio.aws.iot1clickdevices.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.iot1clickdevices.Iot1ClickDevices,
    AwsError,
    zio.aws.iot1clickdevices.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def invokeDeviceMethod(
      request: zio.aws.iot1clickdevices.model.InvokeDeviceMethodRequest
  ): ZIO[
    zio.aws.iot1clickdevices.Iot1ClickDevices,
    AwsError,
    zio.aws.iot1clickdevices.model.InvokeDeviceMethodResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.invokeDeviceMethod(request))
  def tagResource(
      request: zio.aws.iot1clickdevices.model.TagResourceRequest
  ): ZIO[zio.aws.iot1clickdevices.Iot1ClickDevices, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def unclaimDevice(
      request: zio.aws.iot1clickdevices.model.UnclaimDeviceRequest
  ): ZIO[
    zio.aws.iot1clickdevices.Iot1ClickDevices,
    AwsError,
    zio.aws.iot1clickdevices.model.UnclaimDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.unclaimDevice(request))
  def getDeviceMethods(
      request: zio.aws.iot1clickdevices.model.GetDeviceMethodsRequest
  ): ZIO[
    zio.aws.iot1clickdevices.Iot1ClickDevices,
    AwsError,
    zio.aws.iot1clickdevices.model.GetDeviceMethodsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeviceMethods(request))
}
