package zio.aws.iot1clickdevices.model
import zio.prelude.data.Optional
import zio.aws.iot1clickdevices.model.primitives.{MaxResults, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDevicesRequest(
    deviceType: Optional[__string] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesRequest = {
    import ListDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesRequest
      .builder()
      .optionallyWith(deviceType.map(value => value: java.lang.String))(
        _.deviceType
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.iot1clickdevices.model.ListDevicesRequest.ReadOnly =
    zio.aws.iot1clickdevices.model.ListDevicesRequest.wrap(buildAwsValue())
}
object ListDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.ListDevicesRequest =
      zio.aws.iot1clickdevices.model.ListDevicesRequest(
        deviceType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def deviceType: Optional[__string]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def getDeviceType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("deviceType", deviceType)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesRequest
  ) extends zio.aws.iot1clickdevices.model.ListDevicesRequest.ReadOnly {
    override val deviceType: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceType())
      .map(value => value: __string)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot1clickdevices.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesRequest
  ): zio.aws.iot1clickdevices.model.ListDevicesRequest.ReadOnly = new Wrapper(
    impl
  )
}
