package zio.aws.iot1clickdevices.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot1clickdevices.model.primitives.{
  __doubleMin0Max100,
  __boolean,
  __string
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeviceDescription(
    arn: Optional[__string] = Optional.Absent,
    attributes: Optional[Map[__string, __string]] = Optional.Absent,
    deviceId: Optional[__string] = Optional.Absent,
    enabled: Optional[__boolean] = Optional.Absent,
    remainingLife: Optional[__doubleMin0Max100] = Optional.Absent,
    `type`: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.DeviceDescription = {
    import DeviceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.DeviceDescription
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(deviceId.map(value => value: java.lang.String))(
        _.deviceId
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(remainingLife.map(value => value: java.lang.Double))(
        _.remainingLife
      )
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot1clickdevices.model.DeviceDescription.ReadOnly =
    zio.aws.iot1clickdevices.model.DeviceDescription.wrap(buildAwsValue())
}
object DeviceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.DeviceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.DeviceDescription =
      zio.aws.iot1clickdevices.model.DeviceDescription(
        arn.map(value => value),
        attributes.map(value => value),
        deviceId.map(value => value),
        enabled.map(value => value),
        remainingLife.map(value => value),
        `type`.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[__string]
    def attributes: Optional[Map[__string, __string]]
    def deviceId: Optional[__string]
    def enabled: Optional[__boolean]
    def remainingLife: Optional[__doubleMin0Max100]
    def `type`: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getAttributes: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getDeviceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getRemainingLife: ZIO[Any, AwsError, __doubleMin0Max100] =
      AwsError.unwrapOptionField("remainingLife", remainingLife)
    def getType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("type", `type`)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.DeviceDescription
  ) extends zio.aws.iot1clickdevices.model.DeviceDescription.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val attributes: Optional[Map[__string, __string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> (value: __string)
            })
            .toMap
        )
    override val deviceId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => value: __string)
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
    override val remainingLife: Optional[__doubleMin0Max100] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remainingLife())
        .map(value => value: __doubleMin0Max100)
    override val `type`: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.DeviceDescription
  ): zio.aws.iot1clickdevices.model.DeviceDescription.ReadOnly = new Wrapper(
    impl
  )
}
