package zio.aws.iot1clickdevices.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot1clickdevices.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeviceMethod(
    deviceType: Optional[__string] = Optional.Absent,
    methodName: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.DeviceMethod = {
    import DeviceMethod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.DeviceMethod
      .builder()
      .optionallyWith(deviceType.map(value => value: java.lang.String))(
        _.deviceType
      )
      .optionallyWith(methodName.map(value => value: java.lang.String))(
        _.methodName
      )
      .build()
  }
  def asReadOnly: zio.aws.iot1clickdevices.model.DeviceMethod.ReadOnly =
    zio.aws.iot1clickdevices.model.DeviceMethod.wrap(buildAwsValue())
}
object DeviceMethod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.DeviceMethod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.DeviceMethod =
      zio.aws.iot1clickdevices.model.DeviceMethod(
        deviceType.map(value => value),
        methodName.map(value => value)
      )
    def deviceType: Optional[__string]
    def methodName: Optional[__string]
    def getDeviceType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("deviceType", deviceType)
    def getMethodName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("methodName", methodName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.DeviceMethod
  ) extends zio.aws.iot1clickdevices.model.DeviceMethod.ReadOnly {
    override val deviceType: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceType())
      .map(value => value: __string)
    override val methodName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.methodName())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.DeviceMethod
  ): zio.aws.iot1clickdevices.model.DeviceMethod.ReadOnly = new Wrapper(impl)
}
