package zio.aws.iot1clickdevices.model
import zio.prelude.data.Optional
import zio.aws.iot1clickdevices.model.primitives.{__integer, __stringMin12Max40}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ClaimDevicesByClaimCodeResponse(
    claimCode: Optional[__stringMin12Max40] = Optional.Absent,
    total: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse = {
    import ClaimDevicesByClaimCodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse
      .builder()
      .optionallyWith(claimCode.map(value => value: java.lang.String))(
        _.claimCode
      )
      .optionallyWith(total.map(value => value: Integer))(_.total)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse.ReadOnly =
    zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse
      .wrap(buildAwsValue())
}
object ClaimDevicesByClaimCodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse =
      zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse(
        claimCode.map(value => value),
        total.map(value => value)
      )
    def claimCode: Optional[__stringMin12Max40]
    def total: Optional[__integer]
    def getClaimCode: ZIO[Any, AwsError, __stringMin12Max40] =
      AwsError.unwrapOptionField("claimCode", claimCode)
    def getTotal: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("total", total)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse
  ) extends zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse.ReadOnly {
    override val claimCode: Optional[__stringMin12Max40] = zio.aws.core.internal
      .optionalFromNullable(impl.claimCode())
      .map(value => value: __stringMin12Max40)
    override val total: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.total())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse
  ): zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse.ReadOnly =
    new Wrapper(impl)
}
