package zio.aws.iot1clickdevices
import zio.mock.{Proxy, Mock}
import zio.aws.iot1clickdevices.model.FinalizeDeviceClaimResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.iot1clickdevices.Iot1ClickDevicesAsyncClient
import zio.stream.ZStream
import zio.aws.iot1clickdevices.model.{
  GetDeviceMethodsRequest,
  DescribeDeviceRequest,
  ListTagsForResourceRequest,
  ListDeviceEventsRequest,
  UnclaimDeviceRequest,
  ClaimDevicesByClaimCodeRequest,
  InitiateDeviceClaimRequest,
  UntagResourceRequest,
  ListDevicesRequest,
  UpdateDeviceStateRequest,
  InvokeDeviceMethodRequest,
  FinalizeDeviceClaimRequest,
  TagResourceRequest
}
object Iot1ClickDevicesMock extends Mock[Iot1ClickDevices] {
  object InitiateDeviceClaim
      extends Effect[
        InitiateDeviceClaimRequest,
        AwsError,
        zio.aws.iot1clickdevices.model.InitiateDeviceClaimResponse.ReadOnly
      ]
  object DescribeDevice
      extends Effect[
        DescribeDeviceRequest,
        AwsError,
        zio.aws.iot1clickdevices.model.DescribeDeviceResponse.ReadOnly
      ]
  object ListDeviceEvents
      extends Stream[
        ListDeviceEventsRequest,
        AwsError,
        zio.aws.iot1clickdevices.model.DeviceEvent.ReadOnly
      ]
  object ListDeviceEventsPaginated
      extends Effect[
        ListDeviceEventsRequest,
        AwsError,
        zio.aws.iot1clickdevices.model.ListDeviceEventsResponse.ReadOnly
      ]
  object ListDevices
      extends Stream[
        ListDevicesRequest,
        AwsError,
        zio.aws.iot1clickdevices.model.DeviceDescription.ReadOnly
      ]
  object ListDevicesPaginated
      extends Effect[
        ListDevicesRequest,
        AwsError,
        zio.aws.iot1clickdevices.model.ListDevicesResponse.ReadOnly
      ]
  object FinalizeDeviceClaim
      extends Effect[FinalizeDeviceClaimRequest, AwsError, ReadOnly]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object UpdateDeviceState
      extends Effect[
        UpdateDeviceStateRequest,
        AwsError,
        zio.aws.iot1clickdevices.model.UpdateDeviceStateResponse.ReadOnly
      ]
  object ClaimDevicesByClaimCode
      extends Effect[
        ClaimDevicesByClaimCodeRequest,
        AwsError,
        zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.iot1clickdevices.model.ListTagsForResourceResponse.ReadOnly
      ]
  object InvokeDeviceMethod
      extends Effect[
        InvokeDeviceMethodRequest,
        AwsError,
        zio.aws.iot1clickdevices.model.InvokeDeviceMethodResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object UnclaimDevice
      extends Effect[
        UnclaimDeviceRequest,
        AwsError,
        zio.aws.iot1clickdevices.model.UnclaimDeviceResponse.ReadOnly
      ]
  object GetDeviceMethods
      extends Effect[
        GetDeviceMethodsRequest,
        AwsError,
        zio.aws.iot1clickdevices.model.GetDeviceMethodsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Iot1ClickDevices] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Iot1ClickDevices] { rts =>
        zio.ZIO.succeed {
          new Iot1ClickDevices {
            val api: Iot1ClickDevicesAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Iot1ClickDevices = this
            def initiateDeviceClaim(request: InitiateDeviceClaimRequest): IO[
              AwsError,
              zio.aws.iot1clickdevices.model.InitiateDeviceClaimResponse.ReadOnly
            ] = proxy(InitiateDeviceClaim, request)
            def describeDevice(request: DescribeDeviceRequest): IO[
              AwsError,
              zio.aws.iot1clickdevices.model.DescribeDeviceResponse.ReadOnly
            ] = proxy(DescribeDevice, request)
            def listDeviceEvents(request: ListDeviceEventsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iot1clickdevices.model.DeviceEvent.ReadOnly
            ] = rts.unsafeRun(proxy(ListDeviceEvents, request))
            def listDeviceEventsPaginated(request: ListDeviceEventsRequest): IO[
              AwsError,
              zio.aws.iot1clickdevices.model.ListDeviceEventsResponse.ReadOnly
            ] = proxy(ListDeviceEventsPaginated, request)
            def listDevices(request: ListDevicesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iot1clickdevices.model.DeviceDescription.ReadOnly
            ] = rts.unsafeRun(proxy(ListDevices, request))
            def listDevicesPaginated(request: ListDevicesRequest): IO[
              AwsError,
              zio.aws.iot1clickdevices.model.ListDevicesResponse.ReadOnly
            ] = proxy(ListDevicesPaginated, request)
            def finalizeDeviceClaim(
                request: FinalizeDeviceClaimRequest
            ): IO[AwsError, ReadOnly] = proxy(FinalizeDeviceClaim, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def updateDeviceState(request: UpdateDeviceStateRequest): IO[
              AwsError,
              zio.aws.iot1clickdevices.model.UpdateDeviceStateResponse.ReadOnly
            ] = proxy(UpdateDeviceState, request)
            def claimDevicesByClaimCode(
                request: ClaimDevicesByClaimCodeRequest
            ): IO[
              AwsError,
              zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse.ReadOnly
            ] = proxy(ClaimDevicesByClaimCode, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.iot1clickdevices.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def invokeDeviceMethod(request: InvokeDeviceMethodRequest): IO[
              AwsError,
              zio.aws.iot1clickdevices.model.InvokeDeviceMethodResponse.ReadOnly
            ] = proxy(InvokeDeviceMethod, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def unclaimDevice(request: UnclaimDeviceRequest): IO[
              AwsError,
              zio.aws.iot1clickdevices.model.UnclaimDeviceResponse.ReadOnly
            ] = proxy(UnclaimDevice, request)
            def getDeviceMethods(request: GetDeviceMethodsRequest): IO[
              AwsError,
              zio.aws.iot1clickdevices.model.GetDeviceMethodsResponse.ReadOnly
            ] = proxy(GetDeviceMethods, request)
          }
        }
      }
    }
  }
}
