package zio.aws.iot1clickdevices.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot1clickdevices.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListDevicesResponse(
    devices: Option[
      Iterable[zio.aws.iot1clickdevices.model.DeviceDescription]
    ] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesResponse = {
    import ListDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesResponse
      .builder()
      .optionallyWith(
        devices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.devices)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.iot1clickdevices.model.ListDevicesResponse.ReadOnly =
    zio.aws.iot1clickdevices.model.ListDevicesResponse.wrap(buildAwsValue())
}
object ListDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.ListDevicesResponse =
      zio.aws.iot1clickdevices.model.ListDevicesResponse(
        devices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def devices: Option[
      List[zio.aws.iot1clickdevices.model.DeviceDescription.ReadOnly]
    ]
    def nextToken: Option[__string]
    def getDevices: ZIO[Any, AwsError, List[
      zio.aws.iot1clickdevices.model.DeviceDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("devices", devices)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesResponse
  ) extends zio.aws.iot1clickdevices.model.ListDevicesResponse.ReadOnly {
    override val devices: Option[
      List[zio.aws.iot1clickdevices.model.DeviceDescription.ReadOnly]
    ] = scala
      .Option(impl.devices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot1clickdevices.model.DeviceDescription.wrap(item)
        }.toList
      )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesResponse
  ): zio.aws.iot1clickdevices.model.ListDevicesResponse.ReadOnly = new Wrapper(
    impl
  )
}
