package zio.aws.iot1clickdevices.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot1clickdevices.model.primitives.{MaxResults, __string}
import scala.jdk.CollectionConverters._
final case class ListDevicesRequest(
    deviceType: Option[__string] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesRequest = {
    import ListDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesRequest
      .builder()
      .optionallyWith(deviceType.map(value => value: java.lang.String))(
        _.deviceType
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.iot1clickdevices.model.ListDevicesRequest.ReadOnly =
    zio.aws.iot1clickdevices.model.ListDevicesRequest.wrap(buildAwsValue())
}
object ListDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.ListDevicesRequest =
      zio.aws.iot1clickdevices.model.ListDevicesRequest(
        deviceType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def deviceType: Option[__string]
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getDeviceType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("deviceType", deviceType)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesRequest
  ) extends zio.aws.iot1clickdevices.model.ListDevicesRequest.ReadOnly {
    override val deviceType: Option[__string] =
      scala.Option(impl.deviceType()).map(value => value: __string)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot1clickdevices.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesRequest
  ): zio.aws.iot1clickdevices.model.ListDevicesRequest.ReadOnly = new Wrapper(
    impl
  )
}
