package zio.aws.iot1clickdevices.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot1clickdevices.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class Device(
    attributes: Option[zio.aws.iot1clickdevices.model.Attributes] = None,
    deviceId: Option[__string] = None,
    `type`: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.Device = {
    import Device.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.Device
      .builder()
      .optionallyWith(attributes.map(value => value.buildAwsValue()))(
        _.attributes
      )
      .optionallyWith(deviceId.map(value => value: java.lang.String))(
        _.deviceId
      )
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.iot1clickdevices.model.Device.ReadOnly =
    zio.aws.iot1clickdevices.model.Device.wrap(buildAwsValue())
}
object Device {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.Device
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.Device =
      zio.aws.iot1clickdevices.model.Device(
        attributes.map(value => value.asEditable),
        deviceId.map(value => value),
        `type`.map(value => value)
      )
    def attributes: Option[zio.aws.iot1clickdevices.model.Attributes.ReadOnly]
    def deviceId: Option[__string]
    def `type`: Option[__string]
    def getAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.iot1clickdevices.model.Attributes.ReadOnly
    ] = AwsError.unwrapOptionField("attributes", attributes)
    def getDeviceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.Device
  ) extends zio.aws.iot1clickdevices.model.Device.ReadOnly {
    override val attributes
        : Option[zio.aws.iot1clickdevices.model.Attributes.ReadOnly] = scala
      .Option(impl.attributes())
      .map(value => zio.aws.iot1clickdevices.model.Attributes.wrap(value))
    override val deviceId: Option[__string] =
      scala.Option(impl.deviceId()).map(value => value: __string)
    override val `type`: Option[__string] =
      scala.Option(impl.`type`()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.Device
  ): zio.aws.iot1clickdevices.model.Device.ReadOnly = new Wrapper(impl)
}
