package zio.aws.iot1clickdevices.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot1clickdevices.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListDeviceEventsResponse(
    events: Option[Iterable[zio.aws.iot1clickdevices.model.DeviceEvent]] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsResponse = {
    import ListDeviceEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsResponse
      .builder()
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickdevices.model.ListDeviceEventsResponse.ReadOnly =
    zio.aws.iot1clickdevices.model.ListDeviceEventsResponse
      .wrap(buildAwsValue())
}
object ListDeviceEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.ListDeviceEventsResponse =
      zio.aws.iot1clickdevices.model.ListDeviceEventsResponse(
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def events
        : Option[List[zio.aws.iot1clickdevices.model.DeviceEvent.ReadOnly]]
    def nextToken: Option[__string]
    def getEvents: ZIO[Any, AwsError, List[
      zio.aws.iot1clickdevices.model.DeviceEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsResponse
  ) extends zio.aws.iot1clickdevices.model.ListDeviceEventsResponse.ReadOnly {
    override val events
        : Option[List[zio.aws.iot1clickdevices.model.DeviceEvent.ReadOnly]] =
      scala
        .Option(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot1clickdevices.model.DeviceEvent.wrap(item)
          }.toList
        )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsResponse
  ): zio.aws.iot1clickdevices.model.ListDeviceEventsResponse.ReadOnly =
    new Wrapper(impl)
}
