package zio.aws.iot1clickdevices.model
import java.time.Instant
import zio.aws.iot1clickdevices.model.primitives.{
  MaxResults,
  __timestampIso8601,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDeviceEventsRequest(
    deviceId: __string,
    fromTimeStamp: __timestampIso8601,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None,
    toTimeStamp: __timestampIso8601
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsRequest = {
    import ListDeviceEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsRequest
      .builder()
      .deviceId(deviceId: java.lang.String)
      .fromTimeStamp(fromTimeStamp: Instant)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .toTimeStamp(toTimeStamp: Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickdevices.model.ListDeviceEventsRequest.ReadOnly =
    zio.aws.iot1clickdevices.model.ListDeviceEventsRequest.wrap(buildAwsValue())
}
object ListDeviceEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.ListDeviceEventsRequest =
      zio.aws.iot1clickdevices.model.ListDeviceEventsRequest(
        deviceId,
        fromTimeStamp,
        maxResults.map(value => value),
        nextToken.map(value => value),
        toTimeStamp
      )
    def deviceId: __string
    def fromTimeStamp: __timestampIso8601
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def toTimeStamp: __timestampIso8601
    def getDeviceId: ZIO[Any, Nothing, __string] = ZIO.succeed(deviceId)
    def getFromTimeStamp: ZIO[Any, Nothing, __timestampIso8601] =
      ZIO.succeed(fromTimeStamp)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getToTimeStamp: ZIO[Any, Nothing, __timestampIso8601] =
      ZIO.succeed(toTimeStamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsRequest
  ) extends zio.aws.iot1clickdevices.model.ListDeviceEventsRequest.ReadOnly {
    override val deviceId: __string = impl.deviceId(): __string
    override val fromTimeStamp: __timestampIso8601 =
      impl.fromTimeStamp(): __timestampIso8601
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot1clickdevices.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val toTimeStamp: __timestampIso8601 =
      impl.toTimeStamp(): __timestampIso8601
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsRequest
  ): zio.aws.iot1clickdevices.model.ListDeviceEventsRequest.ReadOnly =
    new Wrapper(impl)
}
