package zio.aws.iot1clickdevices.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot1clickdevices.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class FinalizeDeviceClaimRequest(
    deviceId: __string,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.FinalizeDeviceClaimRequest = {
    import FinalizeDeviceClaimRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.FinalizeDeviceClaimRequest
      .builder()
      .deviceId(deviceId: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickdevices.model.FinalizeDeviceClaimRequest.ReadOnly =
    zio.aws.iot1clickdevices.model.FinalizeDeviceClaimRequest
      .wrap(buildAwsValue())
}
object FinalizeDeviceClaimRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.FinalizeDeviceClaimRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.FinalizeDeviceClaimRequest =
      zio.aws.iot1clickdevices.model
        .FinalizeDeviceClaimRequest(deviceId, tags.map(value => value))
    def deviceId: __string
    def tags: Option[Map[__string, __string]]
    def getDeviceId: ZIO[Any, Nothing, __string] = ZIO.succeed(deviceId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.FinalizeDeviceClaimRequest
  ) extends zio.aws.iot1clickdevices.model.FinalizeDeviceClaimRequest.ReadOnly {
    override val deviceId: __string = impl.deviceId(): __string
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.FinalizeDeviceClaimRequest
  ): zio.aws.iot1clickdevices.model.FinalizeDeviceClaimRequest.ReadOnly =
    new Wrapper(impl)
}
