package zio.aws.iot1clickdevices.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot1clickdevices.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class DeviceEvent(
    device: Option[zio.aws.iot1clickdevices.model.Device] = None,
    stdEvent: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.DeviceEvent = {
    import DeviceEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.DeviceEvent
      .builder()
      .optionallyWith(device.map(value => value.buildAwsValue()))(_.device)
      .optionallyWith(stdEvent.map(value => value: java.lang.String))(
        _.stdEvent
      )
      .build()
  }
  def asReadOnly: zio.aws.iot1clickdevices.model.DeviceEvent.ReadOnly =
    zio.aws.iot1clickdevices.model.DeviceEvent.wrap(buildAwsValue())
}
object DeviceEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.DeviceEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.DeviceEvent =
      zio.aws.iot1clickdevices.model.DeviceEvent(
        device.map(value => value.asEditable),
        stdEvent.map(value => value)
      )
    def device: Option[zio.aws.iot1clickdevices.model.Device.ReadOnly]
    def stdEvent: Option[__string]
    def getDevice
        : ZIO[Any, AwsError, zio.aws.iot1clickdevices.model.Device.ReadOnly] =
      AwsError.unwrapOptionField("device", device)
    def getStdEvent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("stdEvent", stdEvent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.DeviceEvent
  ) extends zio.aws.iot1clickdevices.model.DeviceEvent.ReadOnly {
    override val device
        : Option[zio.aws.iot1clickdevices.model.Device.ReadOnly] = scala
      .Option(impl.device())
      .map(value => zio.aws.iot1clickdevices.model.Device.wrap(value))
    override val stdEvent: Option[__string] =
      scala.Option(impl.stdEvent()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.DeviceEvent
  ): zio.aws.iot1clickdevices.model.DeviceEvent.ReadOnly = new Wrapper(impl)
}
