package zio.aws.iot1clickdevices.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDeviceResponse(
    deviceDescription: Option[
      zio.aws.iot1clickdevices.model.DeviceDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.DescribeDeviceResponse = {
    import DescribeDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.DescribeDeviceResponse
      .builder()
      .optionallyWith(deviceDescription.map(value => value.buildAwsValue()))(
        _.deviceDescription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickdevices.model.DescribeDeviceResponse.ReadOnly =
    zio.aws.iot1clickdevices.model.DescribeDeviceResponse.wrap(buildAwsValue())
}
object DescribeDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.DescribeDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.DescribeDeviceResponse =
      zio.aws.iot1clickdevices.model.DescribeDeviceResponse(
        deviceDescription.map(value => value.asEditable)
      )
    def deviceDescription
        : Option[zio.aws.iot1clickdevices.model.DeviceDescription.ReadOnly]
    def getDeviceDescription: ZIO[
      Any,
      AwsError,
      zio.aws.iot1clickdevices.model.DeviceDescription.ReadOnly
    ] = AwsError.unwrapOptionField("deviceDescription", deviceDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.DescribeDeviceResponse
  ) extends zio.aws.iot1clickdevices.model.DescribeDeviceResponse.ReadOnly {
    override val deviceDescription
        : Option[zio.aws.iot1clickdevices.model.DeviceDescription.ReadOnly] =
      scala
        .Option(impl.deviceDescription())
        .map(value =>
          zio.aws.iot1clickdevices.model.DeviceDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.DescribeDeviceResponse
  ): zio.aws.iot1clickdevices.model.DescribeDeviceResponse.ReadOnly =
    new Wrapper(impl)
}
