package zio.aws.iot1clickdevices.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDeviceMethodsResponse(
    deviceMethods: Option[
      Iterable[zio.aws.iot1clickdevices.model.DeviceMethod]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.GetDeviceMethodsResponse = {
    import GetDeviceMethodsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.GetDeviceMethodsResponse
      .builder()
      .optionallyWith(
        deviceMethods.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deviceMethods)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickdevices.model.GetDeviceMethodsResponse.ReadOnly =
    zio.aws.iot1clickdevices.model.GetDeviceMethodsResponse
      .wrap(buildAwsValue())
}
object GetDeviceMethodsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.GetDeviceMethodsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.GetDeviceMethodsResponse =
      zio.aws.iot1clickdevices.model.GetDeviceMethodsResponse(
        deviceMethods.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deviceMethods
        : Option[List[zio.aws.iot1clickdevices.model.DeviceMethod.ReadOnly]]
    def getDeviceMethods: ZIO[Any, AwsError, List[
      zio.aws.iot1clickdevices.model.DeviceMethod.ReadOnly
    ]] = AwsError.unwrapOptionField("deviceMethods", deviceMethods)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.GetDeviceMethodsResponse
  ) extends zio.aws.iot1clickdevices.model.GetDeviceMethodsResponse.ReadOnly {
    override val deviceMethods
        : Option[List[zio.aws.iot1clickdevices.model.DeviceMethod.ReadOnly]] =
      scala
        .Option(impl.deviceMethods())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot1clickdevices.model.DeviceMethod.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.GetDeviceMethodsResponse
  ): zio.aws.iot1clickdevices.model.GetDeviceMethodsResponse.ReadOnly =
    new Wrapper(impl)
}
