package zio.aws.iot1clickdevices.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot1clickdevices.model.primitives.{__integer, __stringMin12Max40}
import scala.jdk.CollectionConverters._
final case class ClaimDevicesByClaimCodeResponse(
    claimCode: Option[__stringMin12Max40] = None,
    total: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse = {
    import ClaimDevicesByClaimCodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse
      .builder()
      .optionallyWith(
        claimCode.map(value =>
          __stringMin12Max40.unwrap(value): java.lang.String
        )
      )(_.claimCode)
      .optionallyWith(total.map(value => __integer.unwrap(value): Integer))(
        _.total
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse.ReadOnly =
    zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse
      .wrap(buildAwsValue())
}
object ClaimDevicesByClaimCodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse =
      zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse(
        claimCode.map(value => value),
        total.map(value => value)
      )
    def claimCode: Option[__stringMin12Max40]
    def total: Option[__integer]
    def getClaimCode: ZIO[Any, AwsError, __stringMin12Max40] =
      AwsError.unwrapOptionField("claimCode", claimCode)
    def getTotal: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("total", total)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse
  ) extends zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse.ReadOnly {
    override val claimCode: Option[__stringMin12Max40] = scala
      .Option(impl.claimCode())
      .map(value =>
        zio.aws.iot1clickdevices.model.primitives.__stringMin12Max40(value)
      )
    override val total: Option[__integer] = scala
      .Option(impl.total())
      .map(value => zio.aws.iot1clickdevices.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse
  ): zio.aws.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse.ReadOnly =
    new Wrapper(impl)
}
