package zio.aws.iot1clickdevices.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iot1clickdevices.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: __string,
    tags: Map[__string, __string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.TagResourceRequest
      .builder()
      .resourceArn(__string.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (__string.unwrap(key): java.lang.String) -> (__string
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.iot1clickdevices.model.TagResourceRequest.ReadOnly =
    zio.aws.iot1clickdevices.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.TagResourceRequest =
      zio.aws.iot1clickdevices.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: __string
    def tags: Map[__string, __string]
    def getResourceArn: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[__string, __string]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.TagResourceRequest
  ) extends zio.aws.iot1clickdevices.model.TagResourceRequest.ReadOnly {
    override val resourceArn: __string =
      zio.aws.iot1clickdevices.model.primitives.__string(impl.resourceArn())
    override val tags: Map[__string, __string] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.iot1clickdevices.model.primitives.__string(
          key
        ) -> zio.aws.iot1clickdevices.model.primitives.__string(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.TagResourceRequest
  ): zio.aws.iot1clickdevices.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
