package zio.aws.iot1clickdevices.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot1clickdevices.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickdevices.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.iot1clickdevices.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.ListTagsForResourceResponse =
      zio.aws.iot1clickdevices.model
        .ListTagsForResourceResponse(tags.map(value => value))
    def tags: Option[Map[__string, __string]]
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ListTagsForResourceResponse
  ) extends zio.aws.iot1clickdevices.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot1clickdevices.model.primitives.__string(
              key
            ) -> zio.aws.iot1clickdevices.model.primitives.__string(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.ListTagsForResourceResponse
  ): zio.aws.iot1clickdevices.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
