package zio.aws.iot1clickdevices.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot1clickdevices.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class InvokeDeviceMethodRequest(
    deviceId: __string,
    deviceMethod: Option[zio.aws.iot1clickdevices.model.DeviceMethod] = None,
    deviceMethodParameters: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.InvokeDeviceMethodRequest = {
    import InvokeDeviceMethodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.InvokeDeviceMethodRequest
      .builder()
      .deviceId(__string.unwrap(deviceId): java.lang.String)
      .optionallyWith(deviceMethod.map(value => value.buildAwsValue()))(
        _.deviceMethod
      )
      .optionallyWith(
        deviceMethodParameters.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.deviceMethodParameters)
      .build()
  }
  def asReadOnly
      : zio.aws.iot1clickdevices.model.InvokeDeviceMethodRequest.ReadOnly =
    zio.aws.iot1clickdevices.model.InvokeDeviceMethodRequest
      .wrap(buildAwsValue())
}
object InvokeDeviceMethodRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.InvokeDeviceMethodRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.InvokeDeviceMethodRequest =
      zio.aws.iot1clickdevices.model.InvokeDeviceMethodRequest(
        deviceId,
        deviceMethod.map(value => value.asEditable),
        deviceMethodParameters.map(value => value)
      )
    def deviceId: __string
    def deviceMethod
        : Option[zio.aws.iot1clickdevices.model.DeviceMethod.ReadOnly]
    def deviceMethodParameters: Option[__string]
    def getDeviceId: ZIO[Any, Nothing, __string] = ZIO.succeed(deviceId)
    def getDeviceMethod: ZIO[
      Any,
      AwsError,
      zio.aws.iot1clickdevices.model.DeviceMethod.ReadOnly
    ] = AwsError.unwrapOptionField("deviceMethod", deviceMethod)
    def getDeviceMethodParameters: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("deviceMethodParameters", deviceMethodParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.InvokeDeviceMethodRequest
  ) extends zio.aws.iot1clickdevices.model.InvokeDeviceMethodRequest.ReadOnly {
    override val deviceId: __string =
      zio.aws.iot1clickdevices.model.primitives.__string(impl.deviceId())
    override val deviceMethod
        : Option[zio.aws.iot1clickdevices.model.DeviceMethod.ReadOnly] = scala
      .Option(impl.deviceMethod())
      .map(value => zio.aws.iot1clickdevices.model.DeviceMethod.wrap(value))
    override val deviceMethodParameters: Option[__string] = scala
      .Option(impl.deviceMethodParameters())
      .map(value => zio.aws.iot1clickdevices.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.InvokeDeviceMethodRequest
  ): zio.aws.iot1clickdevices.model.InvokeDeviceMethodRequest.ReadOnly =
    new Wrapper(impl)
}
