package zio.aws.iot1clickdevices.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot1clickdevices.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class DeviceMethod(
    deviceType: Option[__string] = None,
    methodName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot1clickdevices.model.DeviceMethod = {
    import DeviceMethod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot1clickdevices.model.DeviceMethod
      .builder()
      .optionallyWith(
        deviceType.map(value => __string.unwrap(value): java.lang.String)
      )(_.deviceType)
      .optionallyWith(
        methodName.map(value => __string.unwrap(value): java.lang.String)
      )(_.methodName)
      .build()
  }
  def asReadOnly: zio.aws.iot1clickdevices.model.DeviceMethod.ReadOnly =
    zio.aws.iot1clickdevices.model.DeviceMethod.wrap(buildAwsValue())
}
object DeviceMethod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot1clickdevices.model.DeviceMethod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot1clickdevices.model.DeviceMethod =
      zio.aws.iot1clickdevices.model.DeviceMethod(
        deviceType.map(value => value),
        methodName.map(value => value)
      )
    def deviceType: Option[__string]
    def methodName: Option[__string]
    def getDeviceType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("deviceType", deviceType)
    def getMethodName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("methodName", methodName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.DeviceMethod
  ) extends zio.aws.iot1clickdevices.model.DeviceMethod.ReadOnly {
    override val deviceType: Option[__string] = scala
      .Option(impl.deviceType())
      .map(value => zio.aws.iot1clickdevices.model.primitives.__string(value))
    override val methodName: Option[__string] = scala
      .Option(impl.methodName())
      .map(value => zio.aws.iot1clickdevices.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot1clickdevices.model.DeviceMethod
  ): zio.aws.iot1clickdevices.model.DeviceMethod.ReadOnly = new Wrapper(impl)
}
